/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.DeleteAliasResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DeleteAliasRequest
extends RequestBase {
    private final List<String> index;
    private final List<String> name;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    public static final Endpoint<DeleteAliasRequest, DeleteAliasResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteAliasRequest, DeleteAliasResponse>(request -> "DELETE", request -> {
        boolean _index = true;
        int _name = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_alias");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_aliases");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteAliasResponse._DESERIALIZER);

    public DeleteAliasRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.name = ModelTypeHelper.unmodifiableNonNull(builder.name, "name");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
    }

    public DeleteAliasRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> index() {
        return this.index;
    }

    public List<String> name() {
        return this.name;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<DeleteAliasRequest> {
        private List<String> index;
        private List<String> name;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;

        public Builder index(List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder name(List<String> value) {
            this.name = value;
            return this;
        }

        public Builder name(String ... value) {
            this.name = Arrays.asList(value);
            return this;
        }

        public Builder addName(String value) {
            if (this.name == null) {
                this.name = new ArrayList<String>();
            }
            this.name.add(value);
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public DeleteAliasRequest build() {
            return new DeleteAliasRequest(this);
        }
    }
}

