/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.elasticsearch._core.search.TotalHits;
import co.elastic.clients.elasticsearch.eql.HitsEvent;
import co.elastic.clients.elasticsearch.eql.HitsSequence;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class EqlHits<TEvent>
implements JsonpSerializable {
    @Nullable
    private final TotalHits total;
    @Nullable
    private final List<HitsEvent<TEvent>> events;
    @Nullable
    private final List<HitsSequence<TEvent>> sequences;
    @Nullable
    private final JsonpSerializer<TEvent> tEventSerializer;

    public EqlHits(Builder<TEvent> builder) {
        this.total = ((Builder)builder).total;
        this.events = ModelTypeHelper.unmodifiable(((Builder)builder).events);
        this.sequences = ModelTypeHelper.unmodifiable(((Builder)builder).sequences);
        this.tEventSerializer = ((Builder)builder).tEventSerializer;
    }

    public EqlHits(Function<Builder<TEvent>, Builder<TEvent>> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public TotalHits total() {
        return this.total;
    }

    @Nullable
    public List<HitsEvent<TEvent>> events() {
        return this.events;
    }

    @Nullable
    public List<HitsSequence<TEvent>> sequences() {
        return this.sequences;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
        if (this.events != null) {
            generator.writeKey("events");
            generator.writeStartArray();
            for (HitsEvent hitsEvent : this.events) {
                hitsEvent.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.sequences != null) {
            generator.writeKey("sequences");
            generator.writeStartArray();
            for (HitsSequence hitsSequence : this.sequences) {
                hitsSequence.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public static <TEvent> JsonpDeserializer<EqlHits<TEvent>> createEqlHitsDeserializer(JsonpDeserializer<TEvent> tEventDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> EqlHits.setupEqlHitsDeserializer(op, tEventDeserializer));
    }

    protected static <TEvent> void setupEqlHitsDeserializer(DelegatingDeserializer<Builder<TEvent>> op, JsonpDeserializer<TEvent> tEventDeserializer) {
        op.add(Builder::total, TotalHits._DESERIALIZER, "total", new String[0]);
        op.add(Builder::events, JsonpDeserializer.arrayDeserializer(HitsEvent.createHitsEventDeserializer(tEventDeserializer)), "events", new String[0]);
        op.add(Builder::sequences, JsonpDeserializer.arrayDeserializer(HitsSequence.createHitsSequenceDeserializer(tEventDeserializer)), "sequences", new String[0]);
    }

    public static class Builder<TEvent>
    implements ObjectBuilder<EqlHits<TEvent>> {
        @Nullable
        private TotalHits total;
        @Nullable
        private List<HitsEvent<TEvent>> events;
        @Nullable
        private List<HitsSequence<TEvent>> sequences;
        @Nullable
        private JsonpSerializer<TEvent> tEventSerializer;

        public Builder<TEvent> total(@Nullable TotalHits value) {
            this.total = value;
            return this;
        }

        public Builder<TEvent> total(Function<TotalHits.Builder, ObjectBuilder<TotalHits>> fn) {
            return this.total(fn.apply(new TotalHits.Builder()).build());
        }

        public Builder<TEvent> events(@Nullable List<HitsEvent<TEvent>> value) {
            this.events = value;
            return this;
        }

        public Builder<TEvent> events(HitsEvent<TEvent> ... value) {
            this.events = Arrays.asList(value);
            return this;
        }

        public Builder<TEvent> addEvents(HitsEvent<TEvent> value) {
            if (this.events == null) {
                this.events = new ArrayList<HitsEvent<TEvent>>();
            }
            this.events.add(value);
            return this;
        }

        public Builder<TEvent> events(Function<HitsEvent.Builder<TEvent>, ObjectBuilder<HitsEvent<TEvent>>> fn) {
            return this.events(fn.apply(new HitsEvent.Builder()).build());
        }

        public Builder<TEvent> addEvents(Function<HitsEvent.Builder<TEvent>, ObjectBuilder<HitsEvent<TEvent>>> fn) {
            return this.addEvents(fn.apply(new HitsEvent.Builder()).build());
        }

        public Builder<TEvent> sequences(@Nullable List<HitsSequence<TEvent>> value) {
            this.sequences = value;
            return this;
        }

        public Builder<TEvent> sequences(HitsSequence<TEvent> ... value) {
            this.sequences = Arrays.asList(value);
            return this;
        }

        public Builder<TEvent> addSequences(HitsSequence<TEvent> value) {
            if (this.sequences == null) {
                this.sequences = new ArrayList<HitsSequence<TEvent>>();
            }
            this.sequences.add(value);
            return this;
        }

        public Builder<TEvent> sequences(Function<HitsSequence.Builder<TEvent>, ObjectBuilder<HitsSequence<TEvent>>> fn) {
            return this.sequences(fn.apply(new HitsSequence.Builder()).build());
        }

        public Builder<TEvent> addSequences(Function<HitsSequence.Builder<TEvent>, ObjectBuilder<HitsSequence<TEvent>>> fn) {
            return this.addSequences(fn.apply(new HitsSequence.Builder()).build());
        }

        public Builder<TEvent> tEventSerializer(@Nullable JsonpSerializer<TEvent> value) {
            this.tEventSerializer = value;
            return this;
        }

        @Override
        public EqlHits<TEvent> build() {
            return new EqlHits(this);
        }
    }
}

