/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich;

import co.elastic.clients.elasticsearch.enrich.Policy;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Configuration
implements JsonpSerializable {
    @Nullable
    private final Policy geoMatch;
    private final Policy match;
    public static final JsonpDeserializer<Configuration> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Configuration::setupConfigurationDeserializer, Builder::build);

    public Configuration(Builder builder) {
        this.geoMatch = builder.geoMatch;
        this.match = Objects.requireNonNull(builder.match, "match");
    }

    public Configuration(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Policy geoMatch() {
        return this.geoMatch;
    }

    public Policy match() {
        return this.match;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.geoMatch != null) {
            generator.writeKey("geo_match");
            this.geoMatch.serialize(generator, mapper);
        }
        generator.writeKey("match");
        this.match.serialize(generator, mapper);
    }

    protected static void setupConfigurationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::geoMatch, Policy._DESERIALIZER, "geo_match", new String[0]);
        op.add(Builder::match, Policy._DESERIALIZER, "match", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Configuration> {
        @Nullable
        private Policy geoMatch;
        private Policy match;

        public Builder geoMatch(@Nullable Policy value) {
            this.geoMatch = value;
            return this;
        }

        public Builder geoMatch(Function<Policy.Builder, ObjectBuilder<Policy>> fn) {
            return this.geoMatch(fn.apply(new Policy.Builder()).build());
        }

        public Builder match(Policy value) {
            this.match = value;
            return this;
        }

        public Builder match(Function<Policy.Builder, ObjectBuilder<Policy>> fn) {
            return this.match(fn.apply(new Policy.Builder()).build());
        }

        @Override
        public Configuration build() {
            return new Configuration(this);
        }
    }
}

