/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.FieldTypes;
import co.elastic.clients.elasticsearch.cluster.stats.RuntimeFieldTypes;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FieldTypesMappings
implements JsonpSerializable {
    private final List<FieldTypes> fieldTypes;
    @Nullable
    private final List<RuntimeFieldTypes> runtimeFieldTypes;
    public static final JsonpDeserializer<FieldTypesMappings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldTypesMappings::setupFieldTypesMappingsDeserializer, Builder::build);

    public FieldTypesMappings(Builder builder) {
        this.fieldTypes = ModelTypeHelper.unmodifiableNonNull(builder.fieldTypes, "field_types");
        this.runtimeFieldTypes = ModelTypeHelper.unmodifiable(builder.runtimeFieldTypes);
    }

    public FieldTypesMappings(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<FieldTypes> fieldTypes() {
        return this.fieldTypes;
    }

    @Nullable
    public List<RuntimeFieldTypes> runtimeFieldTypes() {
        return this.runtimeFieldTypes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field_types");
        generator.writeStartArray();
        for (FieldTypes fieldTypes : this.fieldTypes) {
            fieldTypes.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.runtimeFieldTypes != null) {
            generator.writeKey("runtime_field_types");
            generator.writeStartArray();
            for (RuntimeFieldTypes runtimeFieldTypes : this.runtimeFieldTypes) {
                runtimeFieldTypes.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupFieldTypesMappingsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::fieldTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "field_types", new String[0]);
        op.add(Builder::runtimeFieldTypes, JsonpDeserializer.arrayDeserializer(RuntimeFieldTypes._DESERIALIZER), "runtime_field_types", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldTypesMappings> {
        private List<FieldTypes> fieldTypes;
        @Nullable
        private List<RuntimeFieldTypes> runtimeFieldTypes;

        public Builder fieldTypes(List<FieldTypes> value) {
            this.fieldTypes = value;
            return this;
        }

        public Builder fieldTypes(FieldTypes ... value) {
            this.fieldTypes = Arrays.asList(value);
            return this;
        }

        public Builder addFieldTypes(FieldTypes value) {
            if (this.fieldTypes == null) {
                this.fieldTypes = new ArrayList<FieldTypes>();
            }
            this.fieldTypes.add(value);
            return this;
        }

        public Builder fieldTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.fieldTypes(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder addFieldTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.addFieldTypes(fn.apply(new FieldTypes.Builder()).build());
        }

        public Builder runtimeFieldTypes(@Nullable List<RuntimeFieldTypes> value) {
            this.runtimeFieldTypes = value;
            return this;
        }

        public Builder runtimeFieldTypes(RuntimeFieldTypes ... value) {
            this.runtimeFieldTypes = Arrays.asList(value);
            return this;
        }

        public Builder addRuntimeFieldTypes(RuntimeFieldTypes value) {
            if (this.runtimeFieldTypes == null) {
                this.runtimeFieldTypes = new ArrayList<RuntimeFieldTypes>();
            }
            this.runtimeFieldTypes.add(value);
            return this;
        }

        public Builder runtimeFieldTypes(Function<RuntimeFieldTypes.Builder, ObjectBuilder<RuntimeFieldTypes>> fn) {
            return this.runtimeFieldTypes(fn.apply(new RuntimeFieldTypes.Builder()).build());
        }

        public Builder addRuntimeFieldTypes(Function<RuntimeFieldTypes.Builder, ObjectBuilder<RuntimeFieldTypes>> fn) {
            return this.addRuntimeFieldTypes(fn.apply(new RuntimeFieldTypes.Builder()).build());
        }

        @Override
        public FieldTypesMappings build() {
            return new FieldTypesMappings(this);
        }
    }
}

