/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.reroute;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RerouteParameters
implements JsonpSerializable {
    private final boolean allowPrimary;
    private final String index;
    private final String node;
    private final int shard;
    @Nullable
    private final String fromNode;
    @Nullable
    private final String toNode;
    public static final JsonpDeserializer<RerouteParameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteParameters::setupRerouteParametersDeserializer, Builder::build);

    public RerouteParameters(Builder builder) {
        this.allowPrimary = Objects.requireNonNull(builder.allowPrimary, "allow_primary");
        this.index = Objects.requireNonNull(builder.index, "index");
        this.node = Objects.requireNonNull(builder.node, "node");
        this.shard = Objects.requireNonNull(builder.shard, "shard");
        this.fromNode = builder.fromNode;
        this.toNode = builder.toNode;
    }

    public RerouteParameters(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean allowPrimary() {
        return this.allowPrimary;
    }

    public String index() {
        return this.index;
    }

    public String node() {
        return this.node;
    }

    public int shard() {
        return this.shard;
    }

    @Nullable
    public String fromNode() {
        return this.fromNode;
    }

    @Nullable
    public String toNode() {
        return this.toNode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allow_primary");
        generator.write(this.allowPrimary);
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("shard");
        generator.write(this.shard);
        if (this.fromNode != null) {
            generator.writeKey("from_node");
            generator.write(this.fromNode);
        }
        if (this.toNode != null) {
            generator.writeKey("to_node");
            generator.write(this.toNode);
        }
    }

    protected static void setupRerouteParametersDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allowPrimary, JsonpDeserializer.booleanDeserializer(), "allow_primary", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node", new String[0]);
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard", new String[0]);
        op.add(Builder::fromNode, JsonpDeserializer.stringDeserializer(), "from_node", new String[0]);
        op.add(Builder::toNode, JsonpDeserializer.stringDeserializer(), "to_node", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RerouteParameters> {
        private Boolean allowPrimary;
        private String index;
        private String node;
        private Integer shard;
        @Nullable
        private String fromNode;
        @Nullable
        private String toNode;

        public Builder allowPrimary(boolean value) {
            this.allowPrimary = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder node(String value) {
            this.node = value;
            return this;
        }

        public Builder shard(int value) {
            this.shard = value;
            return this;
        }

        public Builder fromNode(@Nullable String value) {
            this.fromNode = value;
            return this;
        }

        public Builder toNode(@Nullable String value) {
            this.toNode = value;
            return this;
        }

        @Override
        public RerouteParameters build() {
            return new RerouteParameters(this);
        }
    }
}

