/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.remote_info;

import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteInfoVariant;
import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteProxyInfo;
import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteSniffInfo;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class ClusterRemoteInfo
implements TaggedUnion<JsonpSerializable>,
JsonpSerializable {
    public static final String SNIFF = "sniff";
    public static final String PROXY = "proxy";
    private final String _type;
    private final JsonpSerializable _value;
    public static final JsonpDeserializer<ClusterRemoteInfo> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, ClusterRemoteInfo::setupClusterRemoteInfoDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public JsonpSerializable _get() {
        return this._value;
    }

    public ClusterRemoteInfo(ClusterRemoteInfoVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private ClusterRemoteInfo(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public ClusterRemoteInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ClusterRemoteSniffInfo sniff() {
        return (ClusterRemoteSniffInfo)TaggedUnionUtils.get(this, SNIFF);
    }

    public ClusterRemoteProxyInfo proxy() {
        return (ClusterRemoteProxyInfo)TaggedUnionUtils.get(this, PROXY);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this._value.serialize(generator, mapper);
    }

    protected static void setupClusterRemoteInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::sniff, ClusterRemoteSniffInfo._DESERIALIZER, SNIFF, new String[0]);
        op.add(Builder::proxy, ClusterRemoteProxyInfo._DESERIALIZER, PROXY, new String[0]);
        op.setTypeProperty("mode");
    }

    public static class Builder
    implements ObjectBuilder<ClusterRemoteInfo> {
        private String _type;
        private JsonpSerializable _value;

        public Builder sniff(ClusterRemoteSniffInfo v) {
            this._type = ClusterRemoteInfo.SNIFF;
            this._value = v;
            return this;
        }

        public Builder sniff(Function<ClusterRemoteSniffInfo.Builder, ObjectBuilder<ClusterRemoteSniffInfo>> f) {
            return this.sniff(f.apply(new ClusterRemoteSniffInfo.Builder()).build());
        }

        public Builder proxy(ClusterRemoteProxyInfo v) {
            this._type = ClusterRemoteInfo.PROXY;
            this._value = v;
            return this;
        }

        public Builder proxy(Function<ClusterRemoteProxyInfo.Builder, ObjectBuilder<ClusterRemoteProxyInfo>> f) {
            return this.proxy(f.apply(new ClusterRemoteProxyInfo.Builder()).build());
        }

        @Override
        public ClusterRemoteInfo build() {
            return new ClusterRemoteInfo(this);
        }
    }
}

