/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr.follow_info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FollowerIndexParameters
implements JsonpSerializable {
    private final int maxOutstandingReadRequests;
    private final int maxOutstandingWriteRequests;
    private final int maxReadRequestOperationCount;
    private final String maxReadRequestSize;
    private final String maxRetryDelay;
    private final int maxWriteBufferCount;
    private final String maxWriteBufferSize;
    private final int maxWriteRequestOperationCount;
    private final String maxWriteRequestSize;
    private final String readPollTimeout;
    public static final JsonpDeserializer<FollowerIndexParameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FollowerIndexParameters::setupFollowerIndexParametersDeserializer, Builder::build);

    public FollowerIndexParameters(Builder builder) {
        this.maxOutstandingReadRequests = Objects.requireNonNull(builder.maxOutstandingReadRequests, "max_outstanding_read_requests");
        this.maxOutstandingWriteRequests = Objects.requireNonNull(builder.maxOutstandingWriteRequests, "max_outstanding_write_requests");
        this.maxReadRequestOperationCount = Objects.requireNonNull(builder.maxReadRequestOperationCount, "max_read_request_operation_count");
        this.maxReadRequestSize = Objects.requireNonNull(builder.maxReadRequestSize, "max_read_request_size");
        this.maxRetryDelay = Objects.requireNonNull(builder.maxRetryDelay, "max_retry_delay");
        this.maxWriteBufferCount = Objects.requireNonNull(builder.maxWriteBufferCount, "max_write_buffer_count");
        this.maxWriteBufferSize = Objects.requireNonNull(builder.maxWriteBufferSize, "max_write_buffer_size");
        this.maxWriteRequestOperationCount = Objects.requireNonNull(builder.maxWriteRequestOperationCount, "max_write_request_operation_count");
        this.maxWriteRequestSize = Objects.requireNonNull(builder.maxWriteRequestSize, "max_write_request_size");
        this.readPollTimeout = Objects.requireNonNull(builder.readPollTimeout, "read_poll_timeout");
    }

    public FollowerIndexParameters(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int maxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    public int maxOutstandingWriteRequests() {
        return this.maxOutstandingWriteRequests;
    }

    public int maxReadRequestOperationCount() {
        return this.maxReadRequestOperationCount;
    }

    public String maxReadRequestSize() {
        return this.maxReadRequestSize;
    }

    public String maxRetryDelay() {
        return this.maxRetryDelay;
    }

    public int maxWriteBufferCount() {
        return this.maxWriteBufferCount;
    }

    public String maxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }

    public int maxWriteRequestOperationCount() {
        return this.maxWriteRequestOperationCount;
    }

    public String maxWriteRequestSize() {
        return this.maxWriteRequestSize;
    }

    public String readPollTimeout() {
        return this.readPollTimeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_outstanding_read_requests");
        generator.write(this.maxOutstandingReadRequests);
        generator.writeKey("max_outstanding_write_requests");
        generator.write(this.maxOutstandingWriteRequests);
        generator.writeKey("max_read_request_operation_count");
        generator.write(this.maxReadRequestOperationCount);
        generator.writeKey("max_read_request_size");
        generator.write(this.maxReadRequestSize);
        generator.writeKey("max_retry_delay");
        generator.write(this.maxRetryDelay);
        generator.writeKey("max_write_buffer_count");
        generator.write(this.maxWriteBufferCount);
        generator.writeKey("max_write_buffer_size");
        generator.write(this.maxWriteBufferSize);
        generator.writeKey("max_write_request_operation_count");
        generator.write(this.maxWriteRequestOperationCount);
        generator.writeKey("max_write_request_size");
        generator.write(this.maxWriteRequestSize);
        generator.writeKey("read_poll_timeout");
        generator.write(this.readPollTimeout);
    }

    protected static void setupFollowerIndexParametersDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::maxOutstandingReadRequests, JsonpDeserializer.integerDeserializer(), "max_outstanding_read_requests", new String[0]);
        op.add(Builder::maxOutstandingWriteRequests, JsonpDeserializer.integerDeserializer(), "max_outstanding_write_requests", new String[0]);
        op.add(Builder::maxReadRequestOperationCount, JsonpDeserializer.integerDeserializer(), "max_read_request_operation_count", new String[0]);
        op.add(Builder::maxReadRequestSize, JsonpDeserializer.stringDeserializer(), "max_read_request_size", new String[0]);
        op.add(Builder::maxRetryDelay, JsonpDeserializer.stringDeserializer(), "max_retry_delay", new String[0]);
        op.add(Builder::maxWriteBufferCount, JsonpDeserializer.integerDeserializer(), "max_write_buffer_count", new String[0]);
        op.add(Builder::maxWriteBufferSize, JsonpDeserializer.stringDeserializer(), "max_write_buffer_size", new String[0]);
        op.add(Builder::maxWriteRequestOperationCount, JsonpDeserializer.integerDeserializer(), "max_write_request_operation_count", new String[0]);
        op.add(Builder::maxWriteRequestSize, JsonpDeserializer.stringDeserializer(), "max_write_request_size", new String[0]);
        op.add(Builder::readPollTimeout, JsonpDeserializer.stringDeserializer(), "read_poll_timeout", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FollowerIndexParameters> {
        private Integer maxOutstandingReadRequests;
        private Integer maxOutstandingWriteRequests;
        private Integer maxReadRequestOperationCount;
        private String maxReadRequestSize;
        private String maxRetryDelay;
        private Integer maxWriteBufferCount;
        private String maxWriteBufferSize;
        private Integer maxWriteRequestOperationCount;
        private String maxWriteRequestSize;
        private String readPollTimeout;

        public Builder maxOutstandingReadRequests(int value) {
            this.maxOutstandingReadRequests = value;
            return this;
        }

        public Builder maxOutstandingWriteRequests(int value) {
            this.maxOutstandingWriteRequests = value;
            return this;
        }

        public Builder maxReadRequestOperationCount(int value) {
            this.maxReadRequestOperationCount = value;
            return this;
        }

        public Builder maxReadRequestSize(String value) {
            this.maxReadRequestSize = value;
            return this;
        }

        public Builder maxRetryDelay(String value) {
            this.maxRetryDelay = value;
            return this;
        }

        public Builder maxWriteBufferCount(int value) {
            this.maxWriteBufferCount = value;
            return this;
        }

        public Builder maxWriteBufferSize(String value) {
            this.maxWriteBufferSize = value;
            return this;
        }

        public Builder maxWriteRequestOperationCount(int value) {
            this.maxWriteRequestOperationCount = value;
            return this;
        }

        public Builder maxWriteRequestSize(String value) {
            this.maxWriteRequestSize = value;
            return this;
        }

        public Builder readPollTimeout(String value) {
            this.readPollTimeout = value;
            return this;
        }

        @Override
        public FollowerIndexParameters build() {
            return new FollowerIndexParameters(this);
        }
    }
}

