/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch.ccr.get_auto_follow_pattern.AutoFollowPattern;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class GetAutoFollowPatternResponse
implements JsonpSerializable {
    private final List<AutoFollowPattern> patterns;
    public static final JsonpDeserializer<GetAutoFollowPatternResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetAutoFollowPatternResponse::setupGetAutoFollowPatternResponseDeserializer, Builder::build);

    public GetAutoFollowPatternResponse(Builder builder) {
        this.patterns = ModelTypeHelper.unmodifiableNonNull(builder.patterns, "patterns");
    }

    public GetAutoFollowPatternResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<AutoFollowPattern> patterns() {
        return this.patterns;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("patterns");
        generator.writeStartArray();
        for (AutoFollowPattern item0 : this.patterns) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetAutoFollowPatternResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::patterns, JsonpDeserializer.arrayDeserializer(AutoFollowPattern._DESERIALIZER), "patterns", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetAutoFollowPatternResponse> {
        private List<AutoFollowPattern> patterns;

        public Builder patterns(List<AutoFollowPattern> value) {
            this.patterns = value;
            return this;
        }

        public Builder patterns(AutoFollowPattern ... value) {
            this.patterns = Arrays.asList(value);
            return this;
        }

        public Builder addPatterns(AutoFollowPattern value) {
            if (this.patterns == null) {
                this.patterns = new ArrayList<AutoFollowPattern>();
            }
            this.patterns.add(value);
            return this;
        }

        public Builder patterns(Function<AutoFollowPattern.Builder, ObjectBuilder<AutoFollowPattern>> fn) {
            return this.patterns(fn.apply(new AutoFollowPattern.Builder()).build());
        }

        public Builder addPatterns(Function<AutoFollowPattern.Builder, ObjectBuilder<AutoFollowPattern>> fn) {
            return this.addPatterns(fn.apply(new AutoFollowPattern.Builder()).build());
        }

        @Override
        public GetAutoFollowPatternResponse build() {
            return new GetAutoFollowPatternResponse(this);
        }
    }
}

