/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch.ccr.ShardStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FollowIndexStats
implements JsonpSerializable {
    private final String index;
    private final List<ShardStats> shards;
    public static final JsonpDeserializer<FollowIndexStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FollowIndexStats::setupFollowIndexStatsDeserializer, Builder::build);

    public FollowIndexStats(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.shards = ModelTypeHelper.unmodifiableNonNull(builder.shards, "shards");
    }

    public FollowIndexStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    public List<ShardStats> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("shards");
        generator.writeStartArray();
        for (ShardStats item0 : this.shards) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupFollowIndexStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(ShardStats._DESERIALIZER), "shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FollowIndexStats> {
        private String index;
        private List<ShardStats> shards;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder shards(List<ShardStats> value) {
            this.shards = value;
            return this;
        }

        public Builder shards(ShardStats ... value) {
            this.shards = Arrays.asList(value);
            return this;
        }

        public Builder addShards(ShardStats value) {
            if (this.shards == null) {
                this.shards = new ArrayList<ShardStats>();
            }
            this.shards.add(value);
            return this;
        }

        public Builder shards(Function<ShardStats.Builder, ObjectBuilder<ShardStats>> fn) {
            return this.shards(fn.apply(new ShardStats.Builder()).build());
        }

        public Builder addShards(Function<ShardStats.Builder, ObjectBuilder<ShardStats>> fn) {
            return this.addShards(fn.apply(new ShardStats.Builder()).build());
        }

        @Override
        public FollowIndexStats build() {
            return new FollowIndexStats(this);
        }
    }
}

