/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat.master;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MasterRecord
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final String host;
    @Nullable
    private final String ip;
    @Nullable
    private final String node;
    public static final JsonpDeserializer<MasterRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MasterRecord::setupMasterRecordDeserializer, Builder::build);

    public MasterRecord(Builder builder) {
        this.id = builder.id;
        this.host = builder.host;
        this.ip = builder.ip;
        this.node = builder.node;
    }

    public MasterRecord(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public String host() {
        return this.host;
    }

    @Nullable
    public String ip() {
        return this.ip;
    }

    @Nullable
    public String node() {
        return this.node;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.host != null) {
            generator.writeKey("host");
            generator.write(this.host);
        }
        if (this.ip != null) {
            generator.writeKey("ip");
            generator.write(this.ip);
        }
        if (this.node != null) {
            generator.writeKey("node");
            generator.write(this.node);
        }
    }

    protected static void setupMasterRecordDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host", "h");
        op.add(Builder::ip, JsonpDeserializer.stringDeserializer(), "ip", new String[0]);
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node", "n");
    }

    public static class Builder
    implements ObjectBuilder<MasterRecord> {
        @Nullable
        private String id;
        @Nullable
        private String host;
        @Nullable
        private String ip;
        @Nullable
        private String node;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder host(@Nullable String value) {
            this.host = value;
            return this;
        }

        public Builder ip(@Nullable String value) {
            this.ip = value;
            return this;
        }

        public Builder node(@Nullable String value) {
            this.node = value;
            return this;
        }

        @Override
        public MasterRecord build() {
            return new MasterRecord(this);
        }
    }
}

