/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.TemplatesResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class TemplatesRequest
extends CatRequestBase {
    @Nullable
    private final String name;
    public static final Endpoint<TemplatesRequest, TemplatesResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<TemplatesRequest, TemplatesResponse>(request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/templates");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/templates");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, TemplatesResponse._DESERIALIZER);

    public TemplatesRequest(Builder builder) {
        this.name = builder.name;
    }

    public TemplatesRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String name() {
        return this.name;
    }

    public static class Builder
    implements ObjectBuilder<TemplatesRequest> {
        @Nullable
        private String name;

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        public TemplatesRequest build() {
            return new TemplatesRequest(this);
        }
    }
}

