/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.TasksResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class TasksRequest
extends CatRequestBase {
    @Nullable
    private final List<String> actions;
    @Nullable
    private final Boolean detailed;
    @Nullable
    private final List<String> nodeId;
    @Nullable
    private final Long parentTask;
    public static final Endpoint<TasksRequest, TasksResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<TasksRequest, TasksResponse>(request -> "GET", request -> "/_cat/tasks", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.actions != null) {
            params.put("actions", request.actions.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.detailed != null) {
            params.put("detailed", String.valueOf(request.detailed));
        }
        if (request.nodeId != null) {
            params.put("node_id", request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.parentTask != null) {
            params.put("parent_task", String.valueOf(request.parentTask));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, TasksResponse._DESERIALIZER);

    public TasksRequest(Builder builder) {
        this.actions = ModelTypeHelper.unmodifiable(builder.actions);
        this.detailed = builder.detailed;
        this.nodeId = ModelTypeHelper.unmodifiable(builder.nodeId);
        this.parentTask = builder.parentTask;
    }

    public TasksRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> actions() {
        return this.actions;
    }

    @Nullable
    public Boolean detailed() {
        return this.detailed;
    }

    @Nullable
    public List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public Long parentTask() {
        return this.parentTask;
    }

    public static class Builder
    implements ObjectBuilder<TasksRequest> {
        @Nullable
        private List<String> actions;
        @Nullable
        private Boolean detailed;
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Long parentTask;

        public Builder actions(@Nullable List<String> value) {
            this.actions = value;
            return this;
        }

        public Builder actions(String ... value) {
            this.actions = Arrays.asList(value);
            return this;
        }

        public Builder addActions(String value) {
            if (this.actions == null) {
                this.actions = new ArrayList<String>();
            }
            this.actions.add(value);
            return this;
        }

        public Builder detailed(@Nullable Boolean value) {
            this.detailed = value;
            return this;
        }

        public Builder nodeId(@Nullable List<String> value) {
            this.nodeId = value;
            return this;
        }

        public Builder nodeId(String ... value) {
            this.nodeId = Arrays.asList(value);
            return this;
        }

        public Builder addNodeId(String value) {
            if (this.nodeId == null) {
                this.nodeId = new ArrayList<String>();
            }
            this.nodeId.add(value);
            return this;
        }

        public Builder parentTask(@Nullable Long value) {
            this.parentTask = value;
            return this;
        }

        @Override
        public TasksRequest build() {
            return new TasksRequest(this);
        }
    }
}

