/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlTrainedModelsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class MlTrainedModelsRequest
extends CatRequestBase {
    @Nullable
    private final String modelId;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    public static final Endpoint<MlTrainedModelsRequest, MlTrainedModelsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<MlTrainedModelsRequest, MlTrainedModelsResponse>(request -> "GET", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (request.modelId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/trained_models");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.toString());
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlTrainedModelsResponse._DESERIALIZER);

    public MlTrainedModelsRequest(Builder builder) {
        this.modelId = builder.modelId;
        this.allowNoMatch = builder.allowNoMatch;
        this.bytes = builder.bytes;
        this.from = builder.from;
        this.size = builder.size;
    }

    public MlTrainedModelsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String modelId() {
        return this.modelId;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    public static class Builder
    implements ObjectBuilder<MlTrainedModelsRequest> {
        @Nullable
        private String modelId;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Bytes bytes;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;

        public Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        public MlTrainedModelsRequest build() {
            return new MlTrainedModelsRequest(this);
        }
    }
}

