/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch.cat.AllocationResponse;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class AllocationRequest
extends CatRequestBase {
    @Nullable
    private final List<String> nodeId;
    @Nullable
    private final Bytes bytes;
    public static final Endpoint<AllocationRequest, AllocationResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<AllocationRequest, AllocationResponse>(request -> "GET", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (request.nodeId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/allocation");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/allocation");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.bytes != null) {
            params.put("bytes", request.bytes.toString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, AllocationResponse._DESERIALIZER);

    public AllocationRequest(Builder builder) {
        this.nodeId = ModelTypeHelper.unmodifiable(builder.nodeId);
        this.bytes = builder.bytes;
    }

    public AllocationRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public Bytes bytes() {
        return this.bytes;
    }

    public static class Builder
    implements ObjectBuilder<AllocationRequest> {
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Bytes bytes;

        public Builder nodeId(@Nullable List<String> value) {
            this.nodeId = value;
            return this;
        }

        public Builder nodeId(String ... value) {
            this.nodeId = Arrays.asList(value);
            return this;
        }

        public Builder addNodeId(String value) {
            if (this.nodeId == null) {
                this.nodeId = new ArrayList<String>();
            }
            this.nodeId.add(value);
            return this;
        }

        public Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        @Override
        public AllocationRequest build() {
            return new AllocationRequest(this);
        }
    }
}

