/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.Objects;

@JsonpDeserializable
public class SpanGapQuery
implements SpanQueryVariant,
JsonpSerializable {
    private final String field;
    private final int spanWidth;
    public static final JsonpDeserializer<SpanGapQuery> _DESERIALIZER = ObjectDeserializer.of(EnumSet.of(JsonParser.Event.START_OBJECT), (parser, mapper, event) -> {
        String name = JsonpUtils.expectKeyName(parser, parser.next());
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.VALUE_NUMBER);
        int spanWidth = parser.getInt();
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
        return new Builder().field(name).spanWidth(spanWidth).build();
    });

    @Override
    public String _variantType() {
        return "span_gap";
    }

    public SpanGapQuery(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.spanWidth = Objects.requireNonNull(builder.spanWidth, "span_width");
    }

    public String field() {
        return this.field;
    }

    public int spanWidth() {
        return this.spanWidth;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.write(this.field, this.spanWidth);
        generator.writeEnd();
    }

    public static class Builder
    implements ObjectBuilder<SpanGapQuery> {
        private String field;
        private Integer spanWidth;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder spanWidth(int value) {
            this.spanWidth = value;
            return this;
        }

        @Override
        public SpanGapQuery build() {
            return new SpanGapQuery(this);
        }
    }
}

