/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ParentIdQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final String id;
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<ParentIdQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ParentIdQuery::setupParentIdQueryDeserializer, Builder::build);

    public ParentIdQuery(Builder builder) {
        super(builder);
        this.id = builder.id;
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.type = builder.type;
    }

    public ParentIdQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "parent_id";
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
    }

    protected static void setupParentIdQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ParentIdQuery> {
        @Nullable
        private String id;
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private String type;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ParentIdQuery build() {
            return new ParentIdQuery(this);
        }
    }
}

