/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class GeoPolygonPoints
implements JsonpSerializable {
    private final List<JsonValue> points;
    public static final JsonpDeserializer<GeoPolygonPoints> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoPolygonPoints::setupGeoPolygonPointsDeserializer, Builder::build);

    public GeoPolygonPoints(Builder builder) {
        this.points = ModelTypeHelper.unmodifiableNonNull(builder.points, "points");
    }

    public GeoPolygonPoints(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<JsonValue> points() {
        return this.points;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("points");
        generator.writeStartArray();
        for (JsonValue item0 : this.points) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupGeoPolygonPointsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::points, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "points", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GeoPolygonPoints> {
        private List<JsonValue> points;

        public Builder points(List<JsonValue> value) {
            this.points = value;
            return this;
        }

        public Builder points(JsonValue ... value) {
            this.points = Arrays.asList(value);
            return this;
        }

        public Builder addPoints(JsonValue value) {
            if (this.points == null) {
                this.points = new ArrayList<JsonValue>();
            }
            this.points.add(value);
            return this;
        }

        @Override
        public GeoPolygonPoints build() {
            return new GeoPolygonPoints(this);
        }
    }
}

