/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.FieldValueFactorScoreFunction;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.RandomScoreFunction;
import co.elastic.clients.elasticsearch._types.query_dsl.ScriptScoreFunction;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FunctionScore
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String EXP = "exp";
    public static final String GAUSS = "gauss";
    public static final String LINEAR = "linear";
    public static final String FIELD_VALUE_FACTOR = "field_value_factor";
    public static final String RANDOM_SCORE = "random_score";
    public static final String SCRIPT_SCORE = "script_score";
    private final String _type;
    private final Object _value;
    @Nullable
    private final Query filter;
    @Nullable
    private final Double weight;
    public static final JsonpDeserializer<FunctionScore> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, FunctionScore::setupFunctionScoreDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public FunctionScore(FunctionScoreVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
        this.filter = null;
        this.weight = null;
    }

    private FunctionScore(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
        this.filter = builder.filter;
        this.weight = builder.weight;
    }

    public FunctionScore(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Query filter() {
        return this.filter;
    }

    @Nullable
    public Double weight() {
        return this.weight;
    }

    public JsonValue exp() {
        return (JsonValue)TaggedUnionUtils.get(this, EXP);
    }

    public JsonValue gauss() {
        return (JsonValue)TaggedUnionUtils.get(this, GAUSS);
    }

    public JsonValue linear() {
        return (JsonValue)TaggedUnionUtils.get(this, LINEAR);
    }

    public FieldValueFactorScoreFunction fieldValueFactor() {
        return (FieldValueFactorScoreFunction)TaggedUnionUtils.get(this, FIELD_VALUE_FACTOR);
    }

    public RandomScoreFunction randomScore() {
        return (RandomScoreFunction)TaggedUnionUtils.get(this, RANDOM_SCORE);
    }

    public ScriptScoreFunction scriptScore() {
        return (ScriptScoreFunction)TaggedUnionUtils.get(this, SCRIPT_SCORE);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.weight != null) {
            generator.writeKey("weight");
            generator.write(this.weight.doubleValue());
        }
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._type) {
                case "exp": {
                    generator.write((JsonValue)this._value);
                    break;
                }
                case "gauss": {
                    generator.write((JsonValue)this._value);
                    break;
                }
                case "linear": {
                    generator.write((JsonValue)this._value);
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupFunctionScoreDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::exp, JsonpDeserializer.jsonValueDeserializer(), EXP, new String[0]);
        op.add(Builder::gauss, JsonpDeserializer.jsonValueDeserializer(), GAUSS, new String[0]);
        op.add(Builder::linear, JsonpDeserializer.jsonValueDeserializer(), LINEAR, new String[0]);
        op.add(Builder::fieldValueFactor, FieldValueFactorScoreFunction._DESERIALIZER, FIELD_VALUE_FACTOR, new String[0]);
        op.add(Builder::randomScore, RandomScoreFunction._DESERIALIZER, RANDOM_SCORE, new String[0]);
        op.add(Builder::scriptScore, ScriptScoreFunction._DESERIALIZER, SCRIPT_SCORE, new String[0]);
        op.add(Builder::filter, Query._DESERIALIZER, "filter", new String[0]);
        op.add(Builder::weight, JsonpDeserializer.doubleDeserializer(), "weight", new String[0]);
    }

    public static class Builder {
        private String _type;
        private Object _value;
        @Nullable
        private Query filter;
        @Nullable
        private Double weight;

        public Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public Builder weight(@Nullable Double value) {
            this.weight = value;
            return this;
        }

        public ContainerBuilder exp(JsonValue v) {
            this._type = FunctionScore.EXP;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder gauss(JsonValue v) {
            this._type = FunctionScore.GAUSS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder linear(JsonValue v) {
            this._type = FunctionScore.LINEAR;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder fieldValueFactor(FieldValueFactorScoreFunction v) {
            this._type = FunctionScore.FIELD_VALUE_FACTOR;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder fieldValueFactor(Function<FieldValueFactorScoreFunction.Builder, ObjectBuilder<FieldValueFactorScoreFunction>> f) {
            return this.fieldValueFactor(f.apply(new FieldValueFactorScoreFunction.Builder()).build());
        }

        public ContainerBuilder randomScore(RandomScoreFunction v) {
            this._type = FunctionScore.RANDOM_SCORE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder randomScore(Function<RandomScoreFunction.Builder, ObjectBuilder<RandomScoreFunction>> f) {
            return this.randomScore(f.apply(new RandomScoreFunction.Builder()).build());
        }

        public ContainerBuilder scriptScore(ScriptScoreFunction v) {
            this._type = FunctionScore.SCRIPT_SCORE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder scriptScore(Function<ScriptScoreFunction.Builder, ObjectBuilder<ScriptScoreFunction>> f) {
            return this.scriptScore(f.apply(new ScriptScoreFunction.Builder()).build());
        }

        protected FunctionScore build() {
            return new FunctionScore(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<FunctionScore> {
            public ContainerBuilder filter(@Nullable Query value) {
                Builder.this.filter = value;
                return this;
            }

            public ContainerBuilder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
                return this.filter(fn.apply(new Query.Builder()).build());
            }

            public ContainerBuilder weight(@Nullable Double value) {
                Builder.this.weight = value;
                return this;
            }

            @Override
            public FunctionScore build() {
                return Builder.this.build();
            }
        }
    }
}

