/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class PropertyBase
implements JsonpSerializable {
    @Nullable
    private final Map<String, JsonData> localMetadata;
    @Nullable
    private final Map<String, String> meta;
    @Nullable
    private final String name;
    @Nullable
    private final Map<String, Property> properties;
    @Nullable
    private final Integer ignoreAbove;
    @Nullable
    private final JsonValue dynamic;
    @Nullable
    private final Map<String, Property> fields;

    public PropertyBase(AbstractBuilder<?> builder) {
        this.localMetadata = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).localMetadata);
        this.meta = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).meta);
        this.name = ((AbstractBuilder)builder).name;
        this.properties = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).properties);
        this.ignoreAbove = ((AbstractBuilder)builder).ignoreAbove;
        this.dynamic = ((AbstractBuilder)builder).dynamic;
        this.fields = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).fields);
    }

    @Nullable
    public Map<String, JsonData> localMetadata() {
        return this.localMetadata;
    }

    @Nullable
    public Map<String, String> meta() {
        return this.meta;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public Map<String, Property> properties() {
        return this.properties;
    }

    @Nullable
    public Integer ignoreAbove() {
        return this.ignoreAbove;
    }

    @Nullable
    public JsonValue dynamic() {
        return this.dynamic;
    }

    @Nullable
    public Map<String, Property> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.localMetadata != null) {
            generator.writeKey("local_metadata");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.localMetadata.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.meta != null) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.properties != null) {
            generator.writeKey("properties");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ignoreAbove != null) {
            generator.writeKey("ignore_above");
            generator.write(this.ignoreAbove.intValue());
        }
        if (this.dynamic != null) {
            generator.writeKey("dynamic");
            generator.write(this.dynamic);
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupPropertyBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::localMetadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "local_metadata", new String[0]);
        op.add(AbstractBuilder::meta, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "meta", new String[0]);
        op.add(AbstractBuilder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(AbstractBuilder::properties, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "properties", new String[0]);
        op.add(AbstractBuilder::ignoreAbove, JsonpDeserializer.integerDeserializer(), "ignore_above", new String[0]);
        op.add(AbstractBuilder::dynamic, JsonpDeserializer.jsonValueDeserializer(), "dynamic", new String[0]);
        op.add(AbstractBuilder::fields, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "fields", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private Map<String, JsonData> localMetadata;
        @Nullable
        private Map<String, String> meta;
        @Nullable
        private String name;
        @Nullable
        private Map<String, Property> properties;
        @Nullable
        private Integer ignoreAbove;
        @Nullable
        private JsonValue dynamic;
        @Nullable
        private Map<String, Property> fields;

        protected AbstractBuilder() {
        }

        public BuilderT localMetadata(@Nullable Map<String, JsonData> value) {
            this.localMetadata = value;
            return this.self();
        }

        public BuilderT putLocalMetadata(String key, JsonData value) {
            if (this.localMetadata == null) {
                this.localMetadata = new HashMap<String, JsonData>();
            }
            this.localMetadata.put(key, value);
            return this.self();
        }

        public BuilderT meta(@Nullable Map<String, String> value) {
            this.meta = value;
            return this.self();
        }

        public BuilderT putMeta(String key, String value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, String>();
            }
            this.meta.put(key, value);
            return this.self();
        }

        public BuilderT name(@Nullable String value) {
            this.name = value;
            return this.self();
        }

        public BuilderT properties(@Nullable Map<String, Property> value) {
            this.properties = value;
            return this.self();
        }

        public BuilderT putProperties(String key, Property value) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Property>();
            }
            this.properties.put(key, value);
            return this.self();
        }

        public BuilderT properties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.properties(Collections.singletonMap(key, fn.apply(new Property.Builder()).build()));
        }

        public BuilderT putProperties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.putProperties(key, fn.apply(new Property.Builder()).build());
        }

        public BuilderT ignoreAbove(@Nullable Integer value) {
            this.ignoreAbove = value;
            return this.self();
        }

        public BuilderT dynamic(@Nullable JsonValue value) {
            this.dynamic = value;
            return this.self();
        }

        public BuilderT fields(@Nullable Map<String, Property> value) {
            this.fields = value;
            return this.self();
        }

        public BuilderT putFields(String key, Property value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, Property>();
            }
            this.fields.put(key, value);
            return this.self();
        }

        public BuilderT fields(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.fields(Collections.singletonMap(key, fn.apply(new Property.Builder()).build()));
        }

        public BuilderT putFields(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.putFields(key, fn.apply(new Property.Builder()).build());
        }

        protected abstract BuilderT self();
    }
}

