/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShingleTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final String fillerToken;
    private final int maxShingleSize;
    private final int minShingleSize;
    private final boolean outputUnigrams;
    private final boolean outputUnigramsIfNoShingles;
    private final String tokenSeparator;
    public static final JsonpDeserializer<ShingleTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShingleTokenFilter::setupShingleTokenFilterDeserializer, Builder::build);

    public ShingleTokenFilter(Builder builder) {
        super(builder);
        this.fillerToken = Objects.requireNonNull(builder.fillerToken, "filler_token");
        this.maxShingleSize = Objects.requireNonNull(builder.maxShingleSize, "max_shingle_size");
        this.minShingleSize = Objects.requireNonNull(builder.minShingleSize, "min_shingle_size");
        this.outputUnigrams = Objects.requireNonNull(builder.outputUnigrams, "output_unigrams");
        this.outputUnigramsIfNoShingles = Objects.requireNonNull(builder.outputUnigramsIfNoShingles, "output_unigrams_if_no_shingles");
        this.tokenSeparator = Objects.requireNonNull(builder.tokenSeparator, "token_separator");
    }

    public ShingleTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "shingle";
    }

    public String fillerToken() {
        return this.fillerToken;
    }

    public int maxShingleSize() {
        return this.maxShingleSize;
    }

    public int minShingleSize() {
        return this.minShingleSize;
    }

    public boolean outputUnigrams() {
        return this.outputUnigrams;
    }

    public boolean outputUnigramsIfNoShingles() {
        return this.outputUnigramsIfNoShingles;
    }

    public String tokenSeparator() {
        return this.tokenSeparator;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "shingle");
        super.serializeInternal(generator, mapper);
        generator.writeKey("filler_token");
        generator.write(this.fillerToken);
        generator.writeKey("max_shingle_size");
        generator.write(this.maxShingleSize);
        generator.writeKey("min_shingle_size");
        generator.write(this.minShingleSize);
        generator.writeKey("output_unigrams");
        generator.write(this.outputUnigrams);
        generator.writeKey("output_unigrams_if_no_shingles");
        generator.write(this.outputUnigramsIfNoShingles);
        generator.writeKey("token_separator");
        generator.write(this.tokenSeparator);
    }

    protected static void setupShingleTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::fillerToken, JsonpDeserializer.stringDeserializer(), "filler_token", new String[0]);
        op.add(Builder::maxShingleSize, JsonpDeserializer.integerDeserializer(), "max_shingle_size", new String[0]);
        op.add(Builder::minShingleSize, JsonpDeserializer.integerDeserializer(), "min_shingle_size", new String[0]);
        op.add(Builder::outputUnigrams, JsonpDeserializer.booleanDeserializer(), "output_unigrams", new String[0]);
        op.add(Builder::outputUnigramsIfNoShingles, JsonpDeserializer.booleanDeserializer(), "output_unigrams_if_no_shingles", new String[0]);
        op.add(Builder::tokenSeparator, JsonpDeserializer.stringDeserializer(), "token_separator", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ShingleTokenFilter> {
        private String fillerToken;
        private Integer maxShingleSize;
        private Integer minShingleSize;
        private Boolean outputUnigrams;
        private Boolean outputUnigramsIfNoShingles;
        private String tokenSeparator;

        public Builder fillerToken(String value) {
            this.fillerToken = value;
            return this;
        }

        public Builder maxShingleSize(int value) {
            this.maxShingleSize = value;
            return this;
        }

        public Builder minShingleSize(int value) {
            this.minShingleSize = value;
            return this;
        }

        public Builder outputUnigrams(boolean value) {
            this.outputUnigrams = value;
            return this;
        }

        public Builder outputUnigramsIfNoShingles(boolean value) {
            this.outputUnigramsIfNoShingles = value;
            return this;
        }

        public Builder tokenSeparator(String value) {
            this.tokenSeparator = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShingleTokenFilter build() {
            return new ShingleTokenFilter(this);
        }
    }
}

