/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CustomNormalizer;
import co.elastic.clients.elasticsearch._types.analysis.LowercaseNormalizer;
import co.elastic.clients.elasticsearch._types.analysis.NormalizerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Normalizer
implements TaggedUnion<JsonpSerializable>,
JsonpSerializable {
    public static final String LOWERCASE = "lowercase";
    public static final String CUSTOM = "custom";
    private final String _type;
    private final JsonpSerializable _value;
    public static final JsonpDeserializer<Normalizer> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Normalizer::setupNormalizerDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public JsonpSerializable _get() {
        return this._value;
    }

    public Normalizer(NormalizerVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Normalizer(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Normalizer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public LowercaseNormalizer lowercase() {
        return (LowercaseNormalizer)TaggedUnionUtils.get(this, LOWERCASE);
    }

    public CustomNormalizer custom() {
        return (CustomNormalizer)TaggedUnionUtils.get(this, CUSTOM);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this._value.serialize(generator, mapper);
    }

    protected static void setupNormalizerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::lowercase, LowercaseNormalizer._DESERIALIZER, LOWERCASE, new String[0]);
        op.add(Builder::custom, CustomNormalizer._DESERIALIZER, CUSTOM, new String[0]);
        op.setTypeProperty("type");
    }

    public static class Builder
    implements ObjectBuilder<Normalizer> {
        private String _type;
        private JsonpSerializable _value;

        public Builder lowercase(LowercaseNormalizer v) {
            this._type = Normalizer.LOWERCASE;
            this._value = v;
            return this;
        }

        public Builder lowercase(Function<LowercaseNormalizer.Builder, ObjectBuilder<LowercaseNormalizer>> f) {
            return this.lowercase(f.apply(new LowercaseNormalizer.Builder()).build());
        }

        public Builder custom(CustomNormalizer v) {
            this._type = Normalizer.CUSTOM;
            this._value = v;
            return this;
        }

        public Builder custom(Function<CustomNormalizer.Builder, ObjectBuilder<CustomNormalizer>> f) {
            return this.custom(f.apply(new CustomNormalizer.Builder()).build());
        }

        @Override
        public Normalizer build() {
            return new Normalizer(this);
        }
    }
}

