/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.EdgeNGramSide;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class EdgeNGramTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final int maxGram;
    private final int minGram;
    private final EdgeNGramSide side;
    public static final JsonpDeserializer<EdgeNGramTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EdgeNGramTokenFilter::setupEdgeNGramTokenFilterDeserializer, Builder::build);

    public EdgeNGramTokenFilter(Builder builder) {
        super(builder);
        this.maxGram = Objects.requireNonNull(builder.maxGram, "max_gram");
        this.minGram = Objects.requireNonNull(builder.minGram, "min_gram");
        this.side = Objects.requireNonNull(builder.side, "side");
    }

    public EdgeNGramTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "edge_ngram";
    }

    public int maxGram() {
        return this.maxGram;
    }

    public int minGram() {
        return this.minGram;
    }

    public EdgeNGramSide side() {
        return this.side;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "edge_ngram");
        super.serializeInternal(generator, mapper);
        generator.writeKey("max_gram");
        generator.write(this.maxGram);
        generator.writeKey("min_gram");
        generator.write(this.minGram);
        generator.writeKey("side");
        this.side.serialize(generator, mapper);
    }

    protected static void setupEdgeNGramTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::maxGram, JsonpDeserializer.integerDeserializer(), "max_gram", new String[0]);
        op.add(Builder::minGram, JsonpDeserializer.integerDeserializer(), "min_gram", new String[0]);
        op.add(Builder::side, EdgeNGramSide._DESERIALIZER, "side", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<EdgeNGramTokenFilter> {
        private Integer maxGram;
        private Integer minGram;
        private EdgeNGramSide side;

        public Builder maxGram(int value) {
            this.maxGram = value;
            return this;
        }

        public Builder minGram(int value) {
            this.minGram = value;
            return this;
        }

        public Builder side(EdgeNGramSide value) {
            this.side = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EdgeNGramTokenFilter build() {
            return new EdgeNGramTokenFilter(this);
        }
    }
}

