/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TestPopulation
implements JsonpSerializable {
    private final String field;
    @Nullable
    private final JsonValue script;
    @Nullable
    private final Query filter;
    public static final JsonpDeserializer<TestPopulation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TestPopulation::setupTestPopulationDeserializer, Builder::build);

    public TestPopulation(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.script = builder.script;
        this.filter = builder.filter;
    }

    public TestPopulation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Nullable
    public Query filter() {
        return this.filter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
    }

    protected static void setupTestPopulationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.add(Builder::filter, Query._DESERIALIZER, "filter", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TestPopulation> {
        private String field;
        @Nullable
        private JsonValue script;
        @Nullable
        private Query filter;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        public Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        @Override
        public TestPopulation build() {
            return new TestPopulation(this);
        }
    }
}

