/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ScriptedMetricAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final JsonValue combineScript;
    @Nullable
    private final JsonValue initScript;
    @Nullable
    private final JsonValue mapScript;
    @Nullable
    private final Map<String, JsonData> params;
    @Nullable
    private final JsonValue reduceScript;
    public static final JsonpDeserializer<ScriptedMetricAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptedMetricAggregation::setupScriptedMetricAggregationDeserializer, Builder::build);

    public ScriptedMetricAggregation(Builder builder) {
        super(builder);
        this.combineScript = builder.combineScript;
        this.initScript = builder.initScript;
        this.mapScript = builder.mapScript;
        this.params = ModelTypeHelper.unmodifiable(builder.params);
        this.reduceScript = builder.reduceScript;
    }

    public ScriptedMetricAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "scripted_metric";
    }

    @Nullable
    public JsonValue combineScript() {
        return this.combineScript;
    }

    @Nullable
    public JsonValue initScript() {
        return this.initScript;
    }

    @Nullable
    public JsonValue mapScript() {
        return this.mapScript;
    }

    @Nullable
    public Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public JsonValue reduceScript() {
        return this.reduceScript;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.combineScript != null) {
            generator.writeKey("combine_script");
            generator.write(this.combineScript);
        }
        if (this.initScript != null) {
            generator.writeKey("init_script");
            generator.write(this.initScript);
        }
        if (this.mapScript != null) {
            generator.writeKey("map_script");
            generator.write(this.mapScript);
        }
        if (this.params != null) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.reduceScript != null) {
            generator.writeKey("reduce_script");
            generator.write(this.reduceScript);
        }
    }

    protected static void setupScriptedMetricAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::combineScript, JsonpDeserializer.jsonValueDeserializer(), "combine_script", new String[0]);
        op.add(Builder::initScript, JsonpDeserializer.jsonValueDeserializer(), "init_script", new String[0]);
        op.add(Builder::mapScript, JsonpDeserializer.jsonValueDeserializer(), "map_script", new String[0]);
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params", new String[0]);
        op.add(Builder::reduceScript, JsonpDeserializer.jsonValueDeserializer(), "reduce_script", new String[0]);
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ScriptedMetricAggregation> {
        @Nullable
        private JsonValue combineScript;
        @Nullable
        private JsonValue initScript;
        @Nullable
        private JsonValue mapScript;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private JsonValue reduceScript;

        public Builder combineScript(@Nullable JsonValue value) {
            this.combineScript = value;
            return this;
        }

        public Builder initScript(@Nullable JsonValue value) {
            this.initScript = value;
            return this;
        }

        public Builder mapScript(@Nullable JsonValue value) {
            this.mapScript = value;
            return this;
        }

        public Builder params(@Nullable Map<String, JsonData> value) {
            this.params = value;
            return this;
        }

        public Builder putParams(String key, JsonData value) {
            if (this.params == null) {
                this.params = new HashMap<String, JsonData>();
            }
            this.params.put(key, value);
            return this;
        }

        public Builder reduceScript(@Nullable JsonValue value) {
            this.reduceScript = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptedMetricAggregation build() {
            return new ScriptedMetricAggregation(this);
        }
    }
}

