/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSource;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CompositeAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final Map<String, String> after;
    @Nullable
    private final Integer size;
    @Nullable
    private final List<Map<String, CompositeAggregationSource>> sources;
    public static final JsonpDeserializer<CompositeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeAggregation::setupCompositeAggregationDeserializer, Builder::build);

    public CompositeAggregation(Builder builder) {
        super(builder);
        this.after = ModelTypeHelper.unmodifiable(builder.after);
        this.size = builder.size;
        this.sources = ModelTypeHelper.unmodifiable(builder.sources);
    }

    public CompositeAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "composite";
    }

    @Nullable
    public Map<String, String> after() {
        return this.after;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public List<Map<String, CompositeAggregationSource>> sources() {
        return this.sources;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.after != null) {
            generator.writeKey("after");
            generator.writeStartObject();
            for (Map.Entry<String, String> entry : this.after.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.sources != null) {
            generator.writeKey("sources");
            generator.writeStartArray();
            for (Map map : this.sources) {
                generator.writeStartObject();
                for (Map.Entry item1 : map.entrySet()) {
                    generator.writeKey((String)item1.getKey());
                    ((CompositeAggregationSource)item1.getValue()).serialize(generator, mapper);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupCompositeAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::after, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "after", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::sources, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(CompositeAggregationSource._DESERIALIZER)), "sources", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CompositeAggregation> {
        @Nullable
        private Map<String, String> after;
        @Nullable
        private Integer size;
        @Nullable
        private List<Map<String, CompositeAggregationSource>> sources;

        public Builder after(@Nullable Map<String, String> value) {
            this.after = value;
            return this;
        }

        public Builder putAfter(String key, String value) {
            if (this.after == null) {
                this.after = new HashMap<String, String>();
            }
            this.after.put(key, value);
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder sources(@Nullable List<Map<String, CompositeAggregationSource>> value) {
            this.sources = value;
            return this;
        }

        public Builder sources(Map<String, CompositeAggregationSource> ... value) {
            this.sources = Arrays.asList(value);
            return this;
        }

        public Builder addSources(Map<String, CompositeAggregationSource> value) {
            if (this.sources == null) {
                this.sources = new ArrayList<Map<String, CompositeAggregationSource>>();
            }
            this.sources.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompositeAggregation build() {
            return new CompositeAggregation(this);
        }
    }
}

