/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AdjacencyMatrixAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.AutoDateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AverageAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AverageBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.BoxplotAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.BucketScriptAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.BucketSelectorAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.BucketSortAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CardinalityAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ChildrenAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CumulativeCardinalityAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CumulativeSumAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DateRangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DerivativeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DiversifiedSamplerAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ExtendedStatsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ExtendedStatsBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FiltersAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoBoundsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoCentroidAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoDistanceAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoHashGridAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoLineAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoTileGridAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GlobalAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.HistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.InferenceAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.IpRangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MatrixStatsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MaxAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MaxBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MedianAbsoluteDeviationAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MinAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MinBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MissingAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MovingAverageAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MovingFunctionAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MovingPercentilesAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MultiTermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.NormalizeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ParentAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.PercentileRanksAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.PercentilesAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.PercentilesBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.RangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.RareTermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.RateAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ReverseNestedAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SamplerAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ScriptedMetricAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SerialDifferencingAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SignificantTermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SignificantTextAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StatsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StatsBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StringStatsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SumAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SumBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TTestAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TopHitsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TopMetricsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ValueCountAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.VariableWidthHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.WeightedAverageAggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Aggregation
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String ADJACENCY_MATRIX = "adjacency_matrix";
    public static final String AUTO_DATE_HISTOGRAM = "auto_date_histogram";
    public static final String AVG = "avg";
    public static final String AVG_BUCKET = "avg_bucket";
    public static final String BOXPLOT = "boxplot";
    public static final String BUCKET_SCRIPT = "bucket_script";
    public static final String BUCKET_SELECTOR = "bucket_selector";
    public static final String BUCKET_SORT = "bucket_sort";
    public static final String CARDINALITY = "cardinality";
    public static final String CHILDREN = "children";
    public static final String COMPOSITE = "composite";
    public static final String CUMULATIVE_CARDINALITY = "cumulative_cardinality";
    public static final String CUMULATIVE_SUM = "cumulative_sum";
    public static final String DATE_HISTOGRAM = "date_histogram";
    public static final String DATE_RANGE = "date_range";
    public static final String DERIVATIVE = "derivative";
    public static final String DIVERSIFIED_SAMPLER = "diversified_sampler";
    public static final String EXTENDED_STATS = "extended_stats";
    public static final String EXTENDED_STATS_BUCKET = "extended_stats_bucket";
    public static final String FILTER = "filter";
    public static final String FILTERS = "filters";
    public static final String GEO_BOUNDS = "geo_bounds";
    public static final String GEO_CENTROID = "geo_centroid";
    public static final String GEO_DISTANCE = "geo_distance";
    public static final String GEOHASH_GRID = "geohash_grid";
    public static final String GEO_LINE = "geo_line";
    public static final String GEOTILE_GRID = "geotile_grid";
    public static final String GLOBAL = "global";
    public static final String HISTOGRAM = "histogram";
    public static final String IP_RANGE = "ip_range";
    public static final String INFERENCE = "inference";
    public static final String MATRIX_STATS = "matrix_stats";
    public static final String MAX = "max";
    public static final String MAX_BUCKET = "max_bucket";
    public static final String MEDIAN_ABSOLUTE_DEVIATION = "median_absolute_deviation";
    public static final String MIN = "min";
    public static final String MIN_BUCKET = "min_bucket";
    public static final String MISSING = "missing";
    public static final String MOVING_AVG = "moving_avg";
    public static final String MOVING_PERCENTILES = "moving_percentiles";
    public static final String MOVING_FN = "moving_fn";
    public static final String MULTI_TERMS = "multi_terms";
    public static final String NESTED = "nested";
    public static final String NORMALIZE = "normalize";
    public static final String PARENT = "parent";
    public static final String PERCENTILE_RANKS = "percentile_ranks";
    public static final String PERCENTILES = "percentiles";
    public static final String PERCENTILES_BUCKET = "percentiles_bucket";
    public static final String RANGE = "range";
    public static final String RARE_TERMS = "rare_terms";
    public static final String RATE = "rate";
    public static final String REVERSE_NESTED = "reverse_nested";
    public static final String SAMPLER = "sampler";
    public static final String SCRIPTED_METRIC = "scripted_metric";
    public static final String SERIAL_DIFF = "serial_diff";
    public static final String SIGNIFICANT_TERMS = "significant_terms";
    public static final String SIGNIFICANT_TEXT = "significant_text";
    public static final String STATS = "stats";
    public static final String STATS_BUCKET = "stats_bucket";
    public static final String STRING_STATS = "string_stats";
    public static final String SUM = "sum";
    public static final String SUM_BUCKET = "sum_bucket";
    public static final String TERMS = "terms";
    public static final String TOP_HITS = "top_hits";
    public static final String T_TEST = "t_test";
    public static final String TOP_METRICS = "top_metrics";
    public static final String VALUE_COUNT = "value_count";
    public static final String WEIGHTED_AVG = "weighted_avg";
    public static final String VARIABLE_WIDTH_HISTOGRAM = "variable_width_histogram";
    private final String _type;
    private final Object _value;
    @Nullable
    private final Map<String, Aggregation> aggs;
    @Nullable
    private final Map<String, JsonData> meta;
    public static final JsonpDeserializer<Aggregation> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Aggregation::setupAggregationDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Aggregation(AggregationVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
        this.aggs = null;
        this.meta = null;
    }

    private Aggregation(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
        this.aggs = ModelTypeHelper.unmodifiable(builder.aggs);
        this.meta = ModelTypeHelper.unmodifiable(builder.meta);
    }

    public Aggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, Aggregation> aggs() {
        return this.aggs;
    }

    @Nullable
    public Map<String, JsonData> meta() {
        return this.meta;
    }

    public AdjacencyMatrixAggregation adjacencyMatrix() {
        return (AdjacencyMatrixAggregation)TaggedUnionUtils.get(this, ADJACENCY_MATRIX);
    }

    public AutoDateHistogramAggregation autoDateHistogram() {
        return (AutoDateHistogramAggregation)TaggedUnionUtils.get(this, AUTO_DATE_HISTOGRAM);
    }

    public AverageAggregation avg() {
        return (AverageAggregation)TaggedUnionUtils.get(this, AVG);
    }

    public AverageBucketAggregation avgBucket() {
        return (AverageBucketAggregation)TaggedUnionUtils.get(this, AVG_BUCKET);
    }

    public BoxplotAggregation boxplot() {
        return (BoxplotAggregation)TaggedUnionUtils.get(this, BOXPLOT);
    }

    public BucketScriptAggregation bucketScript() {
        return (BucketScriptAggregation)TaggedUnionUtils.get(this, BUCKET_SCRIPT);
    }

    public BucketSelectorAggregation bucketSelector() {
        return (BucketSelectorAggregation)TaggedUnionUtils.get(this, BUCKET_SELECTOR);
    }

    public BucketSortAggregation bucketSort() {
        return (BucketSortAggregation)TaggedUnionUtils.get(this, BUCKET_SORT);
    }

    public CardinalityAggregation cardinality() {
        return (CardinalityAggregation)TaggedUnionUtils.get(this, CARDINALITY);
    }

    public ChildrenAggregation children() {
        return (ChildrenAggregation)TaggedUnionUtils.get(this, CHILDREN);
    }

    public CompositeAggregation composite() {
        return (CompositeAggregation)TaggedUnionUtils.get(this, COMPOSITE);
    }

    public CumulativeCardinalityAggregation cumulativeCardinality() {
        return (CumulativeCardinalityAggregation)TaggedUnionUtils.get(this, CUMULATIVE_CARDINALITY);
    }

    public CumulativeSumAggregation cumulativeSum() {
        return (CumulativeSumAggregation)TaggedUnionUtils.get(this, CUMULATIVE_SUM);
    }

    public DateHistogramAggregation dateHistogram() {
        return (DateHistogramAggregation)TaggedUnionUtils.get(this, DATE_HISTOGRAM);
    }

    public DateRangeAggregation dateRange() {
        return (DateRangeAggregation)TaggedUnionUtils.get(this, DATE_RANGE);
    }

    public DerivativeAggregation derivative() {
        return (DerivativeAggregation)TaggedUnionUtils.get(this, DERIVATIVE);
    }

    public DiversifiedSamplerAggregation diversifiedSampler() {
        return (DiversifiedSamplerAggregation)TaggedUnionUtils.get(this, DIVERSIFIED_SAMPLER);
    }

    public ExtendedStatsAggregation extendedStats() {
        return (ExtendedStatsAggregation)TaggedUnionUtils.get(this, EXTENDED_STATS);
    }

    public ExtendedStatsBucketAggregation extendedStatsBucket() {
        return (ExtendedStatsBucketAggregation)TaggedUnionUtils.get(this, EXTENDED_STATS_BUCKET);
    }

    public Query filter() {
        return (Query)TaggedUnionUtils.get(this, FILTER);
    }

    public FiltersAggregation filters() {
        return (FiltersAggregation)TaggedUnionUtils.get(this, FILTERS);
    }

    public GeoBoundsAggregation geoBounds() {
        return (GeoBoundsAggregation)TaggedUnionUtils.get(this, GEO_BOUNDS);
    }

    public GeoCentroidAggregation geoCentroid() {
        return (GeoCentroidAggregation)TaggedUnionUtils.get(this, GEO_CENTROID);
    }

    public GeoDistanceAggregation geoDistance() {
        return (GeoDistanceAggregation)TaggedUnionUtils.get(this, GEO_DISTANCE);
    }

    public GeoHashGridAggregation geohashGrid() {
        return (GeoHashGridAggregation)TaggedUnionUtils.get(this, GEOHASH_GRID);
    }

    public GeoLineAggregation geoLine() {
        return (GeoLineAggregation)TaggedUnionUtils.get(this, GEO_LINE);
    }

    public GeoTileGridAggregation geotileGrid() {
        return (GeoTileGridAggregation)TaggedUnionUtils.get(this, GEOTILE_GRID);
    }

    public GlobalAggregation global() {
        return (GlobalAggregation)TaggedUnionUtils.get(this, GLOBAL);
    }

    public HistogramAggregation histogram() {
        return (HistogramAggregation)TaggedUnionUtils.get(this, HISTOGRAM);
    }

    public IpRangeAggregation ipRange() {
        return (IpRangeAggregation)TaggedUnionUtils.get(this, IP_RANGE);
    }

    public InferenceAggregation inference() {
        return (InferenceAggregation)TaggedUnionUtils.get(this, INFERENCE);
    }

    public MatrixStatsAggregation matrixStats() {
        return (MatrixStatsAggregation)TaggedUnionUtils.get(this, MATRIX_STATS);
    }

    public MaxAggregation max() {
        return (MaxAggregation)TaggedUnionUtils.get(this, MAX);
    }

    public MaxBucketAggregation maxBucket() {
        return (MaxBucketAggregation)TaggedUnionUtils.get(this, MAX_BUCKET);
    }

    public MedianAbsoluteDeviationAggregation medianAbsoluteDeviation() {
        return (MedianAbsoluteDeviationAggregation)TaggedUnionUtils.get(this, MEDIAN_ABSOLUTE_DEVIATION);
    }

    public MinAggregation min() {
        return (MinAggregation)TaggedUnionUtils.get(this, MIN);
    }

    public MinBucketAggregation minBucket() {
        return (MinBucketAggregation)TaggedUnionUtils.get(this, MIN_BUCKET);
    }

    public MissingAggregation missing() {
        return (MissingAggregation)TaggedUnionUtils.get(this, MISSING);
    }

    public MovingAverageAggregation movingAvg() {
        return (MovingAverageAggregation)TaggedUnionUtils.get(this, MOVING_AVG);
    }

    public MovingPercentilesAggregation movingPercentiles() {
        return (MovingPercentilesAggregation)TaggedUnionUtils.get(this, MOVING_PERCENTILES);
    }

    public MovingFunctionAggregation movingFn() {
        return (MovingFunctionAggregation)TaggedUnionUtils.get(this, MOVING_FN);
    }

    public MultiTermsAggregation multiTerms() {
        return (MultiTermsAggregation)TaggedUnionUtils.get(this, MULTI_TERMS);
    }

    public NestedAggregation nested() {
        return (NestedAggregation)TaggedUnionUtils.get(this, NESTED);
    }

    public NormalizeAggregation normalize() {
        return (NormalizeAggregation)TaggedUnionUtils.get(this, NORMALIZE);
    }

    public ParentAggregation parent() {
        return (ParentAggregation)TaggedUnionUtils.get(this, PARENT);
    }

    public PercentileRanksAggregation percentileRanks() {
        return (PercentileRanksAggregation)TaggedUnionUtils.get(this, PERCENTILE_RANKS);
    }

    public PercentilesAggregation percentiles() {
        return (PercentilesAggregation)TaggedUnionUtils.get(this, PERCENTILES);
    }

    public PercentilesBucketAggregation percentilesBucket() {
        return (PercentilesBucketAggregation)TaggedUnionUtils.get(this, PERCENTILES_BUCKET);
    }

    public RangeAggregation range() {
        return (RangeAggregation)TaggedUnionUtils.get(this, RANGE);
    }

    public RareTermsAggregation rareTerms() {
        return (RareTermsAggregation)TaggedUnionUtils.get(this, RARE_TERMS);
    }

    public RateAggregation rate() {
        return (RateAggregation)TaggedUnionUtils.get(this, RATE);
    }

    public ReverseNestedAggregation reverseNested() {
        return (ReverseNestedAggregation)TaggedUnionUtils.get(this, REVERSE_NESTED);
    }

    public SamplerAggregation sampler() {
        return (SamplerAggregation)TaggedUnionUtils.get(this, SAMPLER);
    }

    public ScriptedMetricAggregation scriptedMetric() {
        return (ScriptedMetricAggregation)TaggedUnionUtils.get(this, SCRIPTED_METRIC);
    }

    public SerialDifferencingAggregation serialDiff() {
        return (SerialDifferencingAggregation)TaggedUnionUtils.get(this, SERIAL_DIFF);
    }

    public SignificantTermsAggregation significantTerms() {
        return (SignificantTermsAggregation)TaggedUnionUtils.get(this, SIGNIFICANT_TERMS);
    }

    public SignificantTextAggregation significantText() {
        return (SignificantTextAggregation)TaggedUnionUtils.get(this, SIGNIFICANT_TEXT);
    }

    public StatsAggregation stats() {
        return (StatsAggregation)TaggedUnionUtils.get(this, STATS);
    }

    public StatsBucketAggregation statsBucket() {
        return (StatsBucketAggregation)TaggedUnionUtils.get(this, STATS_BUCKET);
    }

    public StringStatsAggregation stringStats() {
        return (StringStatsAggregation)TaggedUnionUtils.get(this, STRING_STATS);
    }

    public SumAggregation sum() {
        return (SumAggregation)TaggedUnionUtils.get(this, SUM);
    }

    public SumBucketAggregation sumBucket() {
        return (SumBucketAggregation)TaggedUnionUtils.get(this, SUM_BUCKET);
    }

    public TermsAggregation terms() {
        return (TermsAggregation)TaggedUnionUtils.get(this, TERMS);
    }

    public TopHitsAggregation topHits() {
        return (TopHitsAggregation)TaggedUnionUtils.get(this, TOP_HITS);
    }

    public TTestAggregation tTest() {
        return (TTestAggregation)TaggedUnionUtils.get(this, T_TEST);
    }

    public TopMetricsAggregation topMetrics() {
        return (TopMetricsAggregation)TaggedUnionUtils.get(this, TOP_METRICS);
    }

    public ValueCountAggregation valueCount() {
        return (ValueCountAggregation)TaggedUnionUtils.get(this, VALUE_COUNT);
    }

    public WeightedAverageAggregation weightedAvg() {
        return (WeightedAverageAggregation)TaggedUnionUtils.get(this, WEIGHTED_AVG);
    }

    public VariableWidthHistogramAggregation variableWidthHistogram() {
        return (VariableWidthHistogramAggregation)TaggedUnionUtils.get(this, VARIABLE_WIDTH_HISTOGRAM);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        if (this.aggs != null) {
            generator.writeKey("aggs");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.aggs.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Aggregation)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.meta != null) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggs, JsonpDeserializer.stringMapDeserializer(_DESERIALIZER), "aggs", new String[0]);
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "meta", new String[0]);
        op.add(Builder::adjacencyMatrix, AdjacencyMatrixAggregation._DESERIALIZER, ADJACENCY_MATRIX, new String[0]);
        op.add(Builder::autoDateHistogram, AutoDateHistogramAggregation._DESERIALIZER, AUTO_DATE_HISTOGRAM, new String[0]);
        op.add(Builder::avg, AverageAggregation._DESERIALIZER, AVG, new String[0]);
        op.add(Builder::avgBucket, AverageBucketAggregation._DESERIALIZER, AVG_BUCKET, new String[0]);
        op.add(Builder::boxplot, BoxplotAggregation._DESERIALIZER, BOXPLOT, new String[0]);
        op.add(Builder::bucketScript, BucketScriptAggregation._DESERIALIZER, BUCKET_SCRIPT, new String[0]);
        op.add(Builder::bucketSelector, BucketSelectorAggregation._DESERIALIZER, BUCKET_SELECTOR, new String[0]);
        op.add(Builder::bucketSort, BucketSortAggregation._DESERIALIZER, BUCKET_SORT, new String[0]);
        op.add(Builder::cardinality, CardinalityAggregation._DESERIALIZER, CARDINALITY, new String[0]);
        op.add(Builder::children, ChildrenAggregation._DESERIALIZER, CHILDREN, new String[0]);
        op.add(Builder::composite, CompositeAggregation._DESERIALIZER, COMPOSITE, new String[0]);
        op.add(Builder::cumulativeCardinality, CumulativeCardinalityAggregation._DESERIALIZER, CUMULATIVE_CARDINALITY, new String[0]);
        op.add(Builder::cumulativeSum, CumulativeSumAggregation._DESERIALIZER, CUMULATIVE_SUM, new String[0]);
        op.add(Builder::dateHistogram, DateHistogramAggregation._DESERIALIZER, DATE_HISTOGRAM, new String[0]);
        op.add(Builder::dateRange, DateRangeAggregation._DESERIALIZER, DATE_RANGE, new String[0]);
        op.add(Builder::derivative, DerivativeAggregation._DESERIALIZER, DERIVATIVE, new String[0]);
        op.add(Builder::diversifiedSampler, DiversifiedSamplerAggregation._DESERIALIZER, DIVERSIFIED_SAMPLER, new String[0]);
        op.add(Builder::extendedStats, ExtendedStatsAggregation._DESERIALIZER, EXTENDED_STATS, new String[0]);
        op.add(Builder::extendedStatsBucket, ExtendedStatsBucketAggregation._DESERIALIZER, EXTENDED_STATS_BUCKET, new String[0]);
        op.add(Builder::filter, Query._DESERIALIZER, FILTER, new String[0]);
        op.add(Builder::filters, FiltersAggregation._DESERIALIZER, FILTERS, new String[0]);
        op.add(Builder::geoBounds, GeoBoundsAggregation._DESERIALIZER, GEO_BOUNDS, new String[0]);
        op.add(Builder::geoCentroid, GeoCentroidAggregation._DESERIALIZER, GEO_CENTROID, new String[0]);
        op.add(Builder::geoDistance, GeoDistanceAggregation._DESERIALIZER, GEO_DISTANCE, new String[0]);
        op.add(Builder::geohashGrid, GeoHashGridAggregation._DESERIALIZER, GEOHASH_GRID, new String[0]);
        op.add(Builder::geoLine, GeoLineAggregation._DESERIALIZER, GEO_LINE, new String[0]);
        op.add(Builder::geotileGrid, GeoTileGridAggregation._DESERIALIZER, GEOTILE_GRID, new String[0]);
        op.add(Builder::global, GlobalAggregation._DESERIALIZER, GLOBAL, new String[0]);
        op.add(Builder::histogram, HistogramAggregation._DESERIALIZER, HISTOGRAM, new String[0]);
        op.add(Builder::ipRange, IpRangeAggregation._DESERIALIZER, IP_RANGE, new String[0]);
        op.add(Builder::inference, InferenceAggregation._DESERIALIZER, INFERENCE, new String[0]);
        op.add(Builder::matrixStats, MatrixStatsAggregation._DESERIALIZER, MATRIX_STATS, new String[0]);
        op.add(Builder::max, MaxAggregation._DESERIALIZER, MAX, new String[0]);
        op.add(Builder::maxBucket, MaxBucketAggregation._DESERIALIZER, MAX_BUCKET, new String[0]);
        op.add(Builder::medianAbsoluteDeviation, MedianAbsoluteDeviationAggregation._DESERIALIZER, MEDIAN_ABSOLUTE_DEVIATION, new String[0]);
        op.add(Builder::min, MinAggregation._DESERIALIZER, MIN, new String[0]);
        op.add(Builder::minBucket, MinBucketAggregation._DESERIALIZER, MIN_BUCKET, new String[0]);
        op.add(Builder::missing, MissingAggregation._DESERIALIZER, MISSING, new String[0]);
        op.add(Builder::movingAvg, MovingAverageAggregation._DESERIALIZER, MOVING_AVG, new String[0]);
        op.add(Builder::movingPercentiles, MovingPercentilesAggregation._DESERIALIZER, MOVING_PERCENTILES, new String[0]);
        op.add(Builder::movingFn, MovingFunctionAggregation._DESERIALIZER, MOVING_FN, new String[0]);
        op.add(Builder::multiTerms, MultiTermsAggregation._DESERIALIZER, MULTI_TERMS, new String[0]);
        op.add(Builder::nested, NestedAggregation._DESERIALIZER, NESTED, new String[0]);
        op.add(Builder::normalize, NormalizeAggregation._DESERIALIZER, NORMALIZE, new String[0]);
        op.add(Builder::parent, ParentAggregation._DESERIALIZER, PARENT, new String[0]);
        op.add(Builder::percentileRanks, PercentileRanksAggregation._DESERIALIZER, PERCENTILE_RANKS, new String[0]);
        op.add(Builder::percentiles, PercentilesAggregation._DESERIALIZER, PERCENTILES, new String[0]);
        op.add(Builder::percentilesBucket, PercentilesBucketAggregation._DESERIALIZER, PERCENTILES_BUCKET, new String[0]);
        op.add(Builder::range, RangeAggregation._DESERIALIZER, RANGE, new String[0]);
        op.add(Builder::rareTerms, RareTermsAggregation._DESERIALIZER, RARE_TERMS, new String[0]);
        op.add(Builder::rate, RateAggregation._DESERIALIZER, RATE, new String[0]);
        op.add(Builder::reverseNested, ReverseNestedAggregation._DESERIALIZER, REVERSE_NESTED, new String[0]);
        op.add(Builder::sampler, SamplerAggregation._DESERIALIZER, SAMPLER, new String[0]);
        op.add(Builder::scriptedMetric, ScriptedMetricAggregation._DESERIALIZER, SCRIPTED_METRIC, new String[0]);
        op.add(Builder::serialDiff, SerialDifferencingAggregation._DESERIALIZER, SERIAL_DIFF, new String[0]);
        op.add(Builder::significantTerms, SignificantTermsAggregation._DESERIALIZER, SIGNIFICANT_TERMS, new String[0]);
        op.add(Builder::significantText, SignificantTextAggregation._DESERIALIZER, SIGNIFICANT_TEXT, new String[0]);
        op.add(Builder::stats, StatsAggregation._DESERIALIZER, STATS, new String[0]);
        op.add(Builder::statsBucket, StatsBucketAggregation._DESERIALIZER, STATS_BUCKET, new String[0]);
        op.add(Builder::stringStats, StringStatsAggregation._DESERIALIZER, STRING_STATS, new String[0]);
        op.add(Builder::sum, SumAggregation._DESERIALIZER, SUM, new String[0]);
        op.add(Builder::sumBucket, SumBucketAggregation._DESERIALIZER, SUM_BUCKET, new String[0]);
        op.add(Builder::terms, TermsAggregation._DESERIALIZER, TERMS, new String[0]);
        op.add(Builder::topHits, TopHitsAggregation._DESERIALIZER, TOP_HITS, new String[0]);
        op.add(Builder::tTest, TTestAggregation._DESERIALIZER, T_TEST, new String[0]);
        op.add(Builder::topMetrics, TopMetricsAggregation._DESERIALIZER, TOP_METRICS, new String[0]);
        op.add(Builder::valueCount, ValueCountAggregation._DESERIALIZER, VALUE_COUNT, new String[0]);
        op.add(Builder::weightedAvg, WeightedAverageAggregation._DESERIALIZER, WEIGHTED_AVG, new String[0]);
        op.add(Builder::variableWidthHistogram, VariableWidthHistogramAggregation._DESERIALIZER, VARIABLE_WIDTH_HISTOGRAM, new String[0]);
    }

    public static class Builder {
        private String _type;
        private Object _value;
        @Nullable
        private Map<String, Aggregation> aggs;
        @Nullable
        private Map<String, JsonData> meta;

        public Builder aggs(@Nullable Map<String, Aggregation> value) {
            this.aggs = value;
            return this;
        }

        public Builder putAggs(String key, Aggregation value) {
            if (this.aggs == null) {
                this.aggs = new HashMap<String, Aggregation>();
            }
            this.aggs.put(key, value);
            return this;
        }

        public Builder aggs(String key, Function<Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggs(Collections.singletonMap(key, fn.apply(new Builder()).build()));
        }

        public Builder putAggs(String key, Function<Builder, ObjectBuilder<Aggregation>> fn) {
            return this.putAggs(key, fn.apply(new Builder()).build());
        }

        public Builder meta(@Nullable Map<String, JsonData> value) {
            this.meta = value;
            return this;
        }

        public Builder putMeta(String key, JsonData value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, JsonData>();
            }
            this.meta.put(key, value);
            return this;
        }

        public ContainerBuilder adjacencyMatrix(AdjacencyMatrixAggregation v) {
            this._type = Aggregation.ADJACENCY_MATRIX;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder adjacencyMatrix(Function<AdjacencyMatrixAggregation.Builder, ObjectBuilder<AdjacencyMatrixAggregation>> f) {
            return this.adjacencyMatrix(f.apply(new AdjacencyMatrixAggregation.Builder()).build());
        }

        public ContainerBuilder autoDateHistogram(AutoDateHistogramAggregation v) {
            this._type = Aggregation.AUTO_DATE_HISTOGRAM;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder autoDateHistogram(Function<AutoDateHistogramAggregation.Builder, ObjectBuilder<AutoDateHistogramAggregation>> f) {
            return this.autoDateHistogram(f.apply(new AutoDateHistogramAggregation.Builder()).build());
        }

        public ContainerBuilder avg(AverageAggregation v) {
            this._type = Aggregation.AVG;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder avg(Function<AverageAggregation.Builder, ObjectBuilder<AverageAggregation>> f) {
            return this.avg(f.apply(new AverageAggregation.Builder()).build());
        }

        public ContainerBuilder avgBucket(AverageBucketAggregation v) {
            this._type = Aggregation.AVG_BUCKET;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder avgBucket(Function<AverageBucketAggregation.Builder, ObjectBuilder<AverageBucketAggregation>> f) {
            return this.avgBucket(f.apply(new AverageBucketAggregation.Builder()).build());
        }

        public ContainerBuilder boxplot(BoxplotAggregation v) {
            this._type = Aggregation.BOXPLOT;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder boxplot(Function<BoxplotAggregation.Builder, ObjectBuilder<BoxplotAggregation>> f) {
            return this.boxplot(f.apply(new BoxplotAggregation.Builder()).build());
        }

        public ContainerBuilder bucketScript(BucketScriptAggregation v) {
            this._type = Aggregation.BUCKET_SCRIPT;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder bucketScript(Function<BucketScriptAggregation.Builder, ObjectBuilder<BucketScriptAggregation>> f) {
            return this.bucketScript(f.apply(new BucketScriptAggregation.Builder()).build());
        }

        public ContainerBuilder bucketSelector(BucketSelectorAggregation v) {
            this._type = Aggregation.BUCKET_SELECTOR;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder bucketSelector(Function<BucketSelectorAggregation.Builder, ObjectBuilder<BucketSelectorAggregation>> f) {
            return this.bucketSelector(f.apply(new BucketSelectorAggregation.Builder()).build());
        }

        public ContainerBuilder bucketSort(BucketSortAggregation v) {
            this._type = Aggregation.BUCKET_SORT;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder bucketSort(Function<BucketSortAggregation.Builder, ObjectBuilder<BucketSortAggregation>> f) {
            return this.bucketSort(f.apply(new BucketSortAggregation.Builder()).build());
        }

        public ContainerBuilder cardinality(CardinalityAggregation v) {
            this._type = Aggregation.CARDINALITY;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder cardinality(Function<CardinalityAggregation.Builder, ObjectBuilder<CardinalityAggregation>> f) {
            return this.cardinality(f.apply(new CardinalityAggregation.Builder()).build());
        }

        public ContainerBuilder children(ChildrenAggregation v) {
            this._type = Aggregation.CHILDREN;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder children(Function<ChildrenAggregation.Builder, ObjectBuilder<ChildrenAggregation>> f) {
            return this.children(f.apply(new ChildrenAggregation.Builder()).build());
        }

        public ContainerBuilder composite(CompositeAggregation v) {
            this._type = Aggregation.COMPOSITE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder composite(Function<CompositeAggregation.Builder, ObjectBuilder<CompositeAggregation>> f) {
            return this.composite(f.apply(new CompositeAggregation.Builder()).build());
        }

        public ContainerBuilder cumulativeCardinality(CumulativeCardinalityAggregation v) {
            this._type = Aggregation.CUMULATIVE_CARDINALITY;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder cumulativeCardinality(Function<CumulativeCardinalityAggregation.Builder, ObjectBuilder<CumulativeCardinalityAggregation>> f) {
            return this.cumulativeCardinality(f.apply(new CumulativeCardinalityAggregation.Builder()).build());
        }

        public ContainerBuilder cumulativeSum(CumulativeSumAggregation v) {
            this._type = Aggregation.CUMULATIVE_SUM;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder cumulativeSum(Function<CumulativeSumAggregation.Builder, ObjectBuilder<CumulativeSumAggregation>> f) {
            return this.cumulativeSum(f.apply(new CumulativeSumAggregation.Builder()).build());
        }

        public ContainerBuilder dateHistogram(DateHistogramAggregation v) {
            this._type = Aggregation.DATE_HISTOGRAM;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder dateHistogram(Function<DateHistogramAggregation.Builder, ObjectBuilder<DateHistogramAggregation>> f) {
            return this.dateHistogram(f.apply(new DateHistogramAggregation.Builder()).build());
        }

        public ContainerBuilder dateRange(DateRangeAggregation v) {
            this._type = Aggregation.DATE_RANGE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder dateRange(Function<DateRangeAggregation.Builder, ObjectBuilder<DateRangeAggregation>> f) {
            return this.dateRange(f.apply(new DateRangeAggregation.Builder()).build());
        }

        public ContainerBuilder derivative(DerivativeAggregation v) {
            this._type = Aggregation.DERIVATIVE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder derivative(Function<DerivativeAggregation.Builder, ObjectBuilder<DerivativeAggregation>> f) {
            return this.derivative(f.apply(new DerivativeAggregation.Builder()).build());
        }

        public ContainerBuilder diversifiedSampler(DiversifiedSamplerAggregation v) {
            this._type = Aggregation.DIVERSIFIED_SAMPLER;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder diversifiedSampler(Function<DiversifiedSamplerAggregation.Builder, ObjectBuilder<DiversifiedSamplerAggregation>> f) {
            return this.diversifiedSampler(f.apply(new DiversifiedSamplerAggregation.Builder()).build());
        }

        public ContainerBuilder extendedStats(ExtendedStatsAggregation v) {
            this._type = Aggregation.EXTENDED_STATS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder extendedStats(Function<ExtendedStatsAggregation.Builder, ObjectBuilder<ExtendedStatsAggregation>> f) {
            return this.extendedStats(f.apply(new ExtendedStatsAggregation.Builder()).build());
        }

        public ContainerBuilder extendedStatsBucket(ExtendedStatsBucketAggregation v) {
            this._type = Aggregation.EXTENDED_STATS_BUCKET;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder extendedStatsBucket(Function<ExtendedStatsBucketAggregation.Builder, ObjectBuilder<ExtendedStatsBucketAggregation>> f) {
            return this.extendedStatsBucket(f.apply(new ExtendedStatsBucketAggregation.Builder()).build());
        }

        public ContainerBuilder filter(Query v) {
            this._type = Aggregation.FILTER;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder filter(Function<Query.Builder, ObjectBuilder<Query>> f) {
            return this.filter(f.apply(new Query.Builder()).build());
        }

        public ContainerBuilder filters(FiltersAggregation v) {
            this._type = Aggregation.FILTERS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder filters(Function<FiltersAggregation.Builder, ObjectBuilder<FiltersAggregation>> f) {
            return this.filters(f.apply(new FiltersAggregation.Builder()).build());
        }

        public ContainerBuilder geoBounds(GeoBoundsAggregation v) {
            this._type = Aggregation.GEO_BOUNDS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geoBounds(Function<GeoBoundsAggregation.Builder, ObjectBuilder<GeoBoundsAggregation>> f) {
            return this.geoBounds(f.apply(new GeoBoundsAggregation.Builder()).build());
        }

        public ContainerBuilder geoCentroid(GeoCentroidAggregation v) {
            this._type = Aggregation.GEO_CENTROID;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geoCentroid(Function<GeoCentroidAggregation.Builder, ObjectBuilder<GeoCentroidAggregation>> f) {
            return this.geoCentroid(f.apply(new GeoCentroidAggregation.Builder()).build());
        }

        public ContainerBuilder geoDistance(GeoDistanceAggregation v) {
            this._type = Aggregation.GEO_DISTANCE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geoDistance(Function<GeoDistanceAggregation.Builder, ObjectBuilder<GeoDistanceAggregation>> f) {
            return this.geoDistance(f.apply(new GeoDistanceAggregation.Builder()).build());
        }

        public ContainerBuilder geohashGrid(GeoHashGridAggregation v) {
            this._type = Aggregation.GEOHASH_GRID;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geohashGrid(Function<GeoHashGridAggregation.Builder, ObjectBuilder<GeoHashGridAggregation>> f) {
            return this.geohashGrid(f.apply(new GeoHashGridAggregation.Builder()).build());
        }

        public ContainerBuilder geoLine(GeoLineAggregation v) {
            this._type = Aggregation.GEO_LINE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geoLine(Function<GeoLineAggregation.Builder, ObjectBuilder<GeoLineAggregation>> f) {
            return this.geoLine(f.apply(new GeoLineAggregation.Builder()).build());
        }

        public ContainerBuilder geotileGrid(GeoTileGridAggregation v) {
            this._type = Aggregation.GEOTILE_GRID;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geotileGrid(Function<GeoTileGridAggregation.Builder, ObjectBuilder<GeoTileGridAggregation>> f) {
            return this.geotileGrid(f.apply(new GeoTileGridAggregation.Builder()).build());
        }

        public ContainerBuilder global(GlobalAggregation v) {
            this._type = Aggregation.GLOBAL;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder global(Function<GlobalAggregation.Builder, ObjectBuilder<GlobalAggregation>> f) {
            return this.global(f.apply(new GlobalAggregation.Builder()).build());
        }

        public ContainerBuilder histogram(HistogramAggregation v) {
            this._type = Aggregation.HISTOGRAM;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder histogram(Function<HistogramAggregation.Builder, ObjectBuilder<HistogramAggregation>> f) {
            return this.histogram(f.apply(new HistogramAggregation.Builder()).build());
        }

        public ContainerBuilder ipRange(IpRangeAggregation v) {
            this._type = Aggregation.IP_RANGE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder ipRange(Function<IpRangeAggregation.Builder, ObjectBuilder<IpRangeAggregation>> f) {
            return this.ipRange(f.apply(new IpRangeAggregation.Builder()).build());
        }

        public ContainerBuilder inference(InferenceAggregation v) {
            this._type = Aggregation.INFERENCE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder inference(Function<InferenceAggregation.Builder, ObjectBuilder<InferenceAggregation>> f) {
            return this.inference(f.apply(new InferenceAggregation.Builder()).build());
        }

        public ContainerBuilder matrixStats(MatrixStatsAggregation v) {
            this._type = Aggregation.MATRIX_STATS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder matrixStats(Function<MatrixStatsAggregation.Builder, ObjectBuilder<MatrixStatsAggregation>> f) {
            return this.matrixStats(f.apply(new MatrixStatsAggregation.Builder()).build());
        }

        public ContainerBuilder max(MaxAggregation v) {
            this._type = Aggregation.MAX;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder max(Function<MaxAggregation.Builder, ObjectBuilder<MaxAggregation>> f) {
            return this.max(f.apply(new MaxAggregation.Builder()).build());
        }

        public ContainerBuilder maxBucket(MaxBucketAggregation v) {
            this._type = Aggregation.MAX_BUCKET;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder maxBucket(Function<MaxBucketAggregation.Builder, ObjectBuilder<MaxBucketAggregation>> f) {
            return this.maxBucket(f.apply(new MaxBucketAggregation.Builder()).build());
        }

        public ContainerBuilder medianAbsoluteDeviation(MedianAbsoluteDeviationAggregation v) {
            this._type = Aggregation.MEDIAN_ABSOLUTE_DEVIATION;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder medianAbsoluteDeviation(Function<MedianAbsoluteDeviationAggregation.Builder, ObjectBuilder<MedianAbsoluteDeviationAggregation>> f) {
            return this.medianAbsoluteDeviation(f.apply(new MedianAbsoluteDeviationAggregation.Builder()).build());
        }

        public ContainerBuilder min(MinAggregation v) {
            this._type = Aggregation.MIN;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder min(Function<MinAggregation.Builder, ObjectBuilder<MinAggregation>> f) {
            return this.min(f.apply(new MinAggregation.Builder()).build());
        }

        public ContainerBuilder minBucket(MinBucketAggregation v) {
            this._type = Aggregation.MIN_BUCKET;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder minBucket(Function<MinBucketAggregation.Builder, ObjectBuilder<MinBucketAggregation>> f) {
            return this.minBucket(f.apply(new MinBucketAggregation.Builder()).build());
        }

        public ContainerBuilder missing(MissingAggregation v) {
            this._type = Aggregation.MISSING;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder missing(Function<MissingAggregation.Builder, ObjectBuilder<MissingAggregation>> f) {
            return this.missing(f.apply(new MissingAggregation.Builder()).build());
        }

        public ContainerBuilder movingAvg(MovingAverageAggregation v) {
            this._type = Aggregation.MOVING_AVG;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder movingAvg(Function<MovingAverageAggregation.Builder, ObjectBuilder<MovingAverageAggregation>> f) {
            return this.movingAvg(f.apply(new MovingAverageAggregation.Builder()).build());
        }

        public ContainerBuilder movingPercentiles(MovingPercentilesAggregation v) {
            this._type = Aggregation.MOVING_PERCENTILES;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder movingPercentiles(Function<MovingPercentilesAggregation.Builder, ObjectBuilder<MovingPercentilesAggregation>> f) {
            return this.movingPercentiles(f.apply(new MovingPercentilesAggregation.Builder()).build());
        }

        public ContainerBuilder movingFn(MovingFunctionAggregation v) {
            this._type = Aggregation.MOVING_FN;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder movingFn(Function<MovingFunctionAggregation.Builder, ObjectBuilder<MovingFunctionAggregation>> f) {
            return this.movingFn(f.apply(new MovingFunctionAggregation.Builder()).build());
        }

        public ContainerBuilder multiTerms(MultiTermsAggregation v) {
            this._type = Aggregation.MULTI_TERMS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder multiTerms(Function<MultiTermsAggregation.Builder, ObjectBuilder<MultiTermsAggregation>> f) {
            return this.multiTerms(f.apply(new MultiTermsAggregation.Builder()).build());
        }

        public ContainerBuilder nested(NestedAggregation v) {
            this._type = Aggregation.NESTED;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder nested(Function<NestedAggregation.Builder, ObjectBuilder<NestedAggregation>> f) {
            return this.nested(f.apply(new NestedAggregation.Builder()).build());
        }

        public ContainerBuilder normalize(NormalizeAggregation v) {
            this._type = Aggregation.NORMALIZE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder normalize(Function<NormalizeAggregation.Builder, ObjectBuilder<NormalizeAggregation>> f) {
            return this.normalize(f.apply(new NormalizeAggregation.Builder()).build());
        }

        public ContainerBuilder parent(ParentAggregation v) {
            this._type = Aggregation.PARENT;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder parent(Function<ParentAggregation.Builder, ObjectBuilder<ParentAggregation>> f) {
            return this.parent(f.apply(new ParentAggregation.Builder()).build());
        }

        public ContainerBuilder percentileRanks(PercentileRanksAggregation v) {
            this._type = Aggregation.PERCENTILE_RANKS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder percentileRanks(Function<PercentileRanksAggregation.Builder, ObjectBuilder<PercentileRanksAggregation>> f) {
            return this.percentileRanks(f.apply(new PercentileRanksAggregation.Builder()).build());
        }

        public ContainerBuilder percentiles(PercentilesAggregation v) {
            this._type = Aggregation.PERCENTILES;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder percentiles(Function<PercentilesAggregation.Builder, ObjectBuilder<PercentilesAggregation>> f) {
            return this.percentiles(f.apply(new PercentilesAggregation.Builder()).build());
        }

        public ContainerBuilder percentilesBucket(PercentilesBucketAggregation v) {
            this._type = Aggregation.PERCENTILES_BUCKET;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder percentilesBucket(Function<PercentilesBucketAggregation.Builder, ObjectBuilder<PercentilesBucketAggregation>> f) {
            return this.percentilesBucket(f.apply(new PercentilesBucketAggregation.Builder()).build());
        }

        public ContainerBuilder range(RangeAggregation v) {
            this._type = Aggregation.RANGE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder range(Function<RangeAggregation.Builder, ObjectBuilder<RangeAggregation>> f) {
            return this.range(f.apply(new RangeAggregation.Builder()).build());
        }

        public ContainerBuilder rareTerms(RareTermsAggregation v) {
            this._type = Aggregation.RARE_TERMS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder rareTerms(Function<RareTermsAggregation.Builder, ObjectBuilder<RareTermsAggregation>> f) {
            return this.rareTerms(f.apply(new RareTermsAggregation.Builder()).build());
        }

        public ContainerBuilder rate(RateAggregation v) {
            this._type = Aggregation.RATE;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder rate(Function<RateAggregation.Builder, ObjectBuilder<RateAggregation>> f) {
            return this.rate(f.apply(new RateAggregation.Builder()).build());
        }

        public ContainerBuilder reverseNested(ReverseNestedAggregation v) {
            this._type = Aggregation.REVERSE_NESTED;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder reverseNested(Function<ReverseNestedAggregation.Builder, ObjectBuilder<ReverseNestedAggregation>> f) {
            return this.reverseNested(f.apply(new ReverseNestedAggregation.Builder()).build());
        }

        public ContainerBuilder sampler(SamplerAggregation v) {
            this._type = Aggregation.SAMPLER;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder sampler(Function<SamplerAggregation.Builder, ObjectBuilder<SamplerAggregation>> f) {
            return this.sampler(f.apply(new SamplerAggregation.Builder()).build());
        }

        public ContainerBuilder scriptedMetric(ScriptedMetricAggregation v) {
            this._type = Aggregation.SCRIPTED_METRIC;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder scriptedMetric(Function<ScriptedMetricAggregation.Builder, ObjectBuilder<ScriptedMetricAggregation>> f) {
            return this.scriptedMetric(f.apply(new ScriptedMetricAggregation.Builder()).build());
        }

        public ContainerBuilder serialDiff(SerialDifferencingAggregation v) {
            this._type = Aggregation.SERIAL_DIFF;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder serialDiff(Function<SerialDifferencingAggregation.Builder, ObjectBuilder<SerialDifferencingAggregation>> f) {
            return this.serialDiff(f.apply(new SerialDifferencingAggregation.Builder()).build());
        }

        public ContainerBuilder significantTerms(SignificantTermsAggregation v) {
            this._type = Aggregation.SIGNIFICANT_TERMS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder significantTerms(Function<SignificantTermsAggregation.Builder, ObjectBuilder<SignificantTermsAggregation>> f) {
            return this.significantTerms(f.apply(new SignificantTermsAggregation.Builder()).build());
        }

        public ContainerBuilder significantText(SignificantTextAggregation v) {
            this._type = Aggregation.SIGNIFICANT_TEXT;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder significantText(Function<SignificantTextAggregation.Builder, ObjectBuilder<SignificantTextAggregation>> f) {
            return this.significantText(f.apply(new SignificantTextAggregation.Builder()).build());
        }

        public ContainerBuilder stats(StatsAggregation v) {
            this._type = Aggregation.STATS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder stats(Function<StatsAggregation.Builder, ObjectBuilder<StatsAggregation>> f) {
            return this.stats(f.apply(new StatsAggregation.Builder()).build());
        }

        public ContainerBuilder statsBucket(StatsBucketAggregation v) {
            this._type = Aggregation.STATS_BUCKET;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder statsBucket(Function<StatsBucketAggregation.Builder, ObjectBuilder<StatsBucketAggregation>> f) {
            return this.statsBucket(f.apply(new StatsBucketAggregation.Builder()).build());
        }

        public ContainerBuilder stringStats(StringStatsAggregation v) {
            this._type = Aggregation.STRING_STATS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder stringStats(Function<StringStatsAggregation.Builder, ObjectBuilder<StringStatsAggregation>> f) {
            return this.stringStats(f.apply(new StringStatsAggregation.Builder()).build());
        }

        public ContainerBuilder sum(SumAggregation v) {
            this._type = Aggregation.SUM;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder sum(Function<SumAggregation.Builder, ObjectBuilder<SumAggregation>> f) {
            return this.sum(f.apply(new SumAggregation.Builder()).build());
        }

        public ContainerBuilder sumBucket(SumBucketAggregation v) {
            this._type = Aggregation.SUM_BUCKET;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder sumBucket(Function<SumBucketAggregation.Builder, ObjectBuilder<SumBucketAggregation>> f) {
            return this.sumBucket(f.apply(new SumBucketAggregation.Builder()).build());
        }

        public ContainerBuilder terms(TermsAggregation v) {
            this._type = Aggregation.TERMS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder terms(Function<TermsAggregation.Builder, ObjectBuilder<TermsAggregation>> f) {
            return this.terms(f.apply(new TermsAggregation.Builder()).build());
        }

        public ContainerBuilder topHits(TopHitsAggregation v) {
            this._type = Aggregation.TOP_HITS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder topHits(Function<TopHitsAggregation.Builder, ObjectBuilder<TopHitsAggregation>> f) {
            return this.topHits(f.apply(new TopHitsAggregation.Builder()).build());
        }

        public ContainerBuilder tTest(TTestAggregation v) {
            this._type = Aggregation.T_TEST;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder tTest(Function<TTestAggregation.Builder, ObjectBuilder<TTestAggregation>> f) {
            return this.tTest(f.apply(new TTestAggregation.Builder()).build());
        }

        public ContainerBuilder topMetrics(TopMetricsAggregation v) {
            this._type = Aggregation.TOP_METRICS;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder topMetrics(Function<TopMetricsAggregation.Builder, ObjectBuilder<TopMetricsAggregation>> f) {
            return this.topMetrics(f.apply(new TopMetricsAggregation.Builder()).build());
        }

        public ContainerBuilder valueCount(ValueCountAggregation v) {
            this._type = Aggregation.VALUE_COUNT;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder valueCount(Function<ValueCountAggregation.Builder, ObjectBuilder<ValueCountAggregation>> f) {
            return this.valueCount(f.apply(new ValueCountAggregation.Builder()).build());
        }

        public ContainerBuilder weightedAvg(WeightedAverageAggregation v) {
            this._type = Aggregation.WEIGHTED_AVG;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder weightedAvg(Function<WeightedAverageAggregation.Builder, ObjectBuilder<WeightedAverageAggregation>> f) {
            return this.weightedAvg(f.apply(new WeightedAverageAggregation.Builder()).build());
        }

        public ContainerBuilder variableWidthHistogram(VariableWidthHistogramAggregation v) {
            this._type = Aggregation.VARIABLE_WIDTH_HISTOGRAM;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder variableWidthHistogram(Function<VariableWidthHistogramAggregation.Builder, ObjectBuilder<VariableWidthHistogramAggregation>> f) {
            return this.variableWidthHistogram(f.apply(new VariableWidthHistogramAggregation.Builder()).build());
        }

        protected Aggregation build() {
            return new Aggregation(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<Aggregation> {
            public ContainerBuilder aggs(@Nullable Map<String, Aggregation> value) {
                Builder.this.aggs = value;
                return this;
            }

            public ContainerBuilder putAggs(String key, Aggregation value) {
                if (Builder.this.aggs == null) {
                    Builder.this.aggs = new HashMap();
                }
                Builder.this.aggs.put(key, value);
                return this;
            }

            public ContainerBuilder aggs(String key, Function<Builder, ObjectBuilder<Aggregation>> fn) {
                return this.aggs(Collections.singletonMap(key, fn.apply(new Builder()).build()));
            }

            public ContainerBuilder putAggs(String key, Function<Builder, ObjectBuilder<Aggregation>> fn) {
                return this.putAggs(key, fn.apply(new Builder()).build());
            }

            public ContainerBuilder meta(@Nullable Map<String, JsonData> value) {
                Builder.this.meta = value;
                return this;
            }

            public ContainerBuilder putMeta(String key, JsonData value) {
                if (Builder.this.meta == null) {
                    Builder.this.meta = new HashMap();
                }
                Builder.this.meta.put(key, value);
                return this;
            }

            @Override
            public Aggregation build() {
                return Builder.this.build();
            }
        }
    }
}

