/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ScriptField
implements JsonpSerializable {
    private final JsonValue script;
    @Nullable
    private final Boolean ignoreFailure;
    public static final JsonpDeserializer<ScriptField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptField::setupScriptFieldDeserializer, Builder::build);

    public ScriptField(Builder builder) {
        this.script = Objects.requireNonNull(builder.script, "script");
        this.ignoreFailure = builder.ignoreFailure;
    }

    public ScriptField(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public JsonValue script() {
        return this.script;
    }

    @Nullable
    public Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("script");
        generator.write(this.script);
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure.booleanValue());
        }
    }

    protected static void setupScriptFieldDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.add(Builder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ScriptField> {
        private JsonValue script;
        @Nullable
        private Boolean ignoreFailure;

        public Builder script(JsonValue value) {
            this.script = value;
            return this;
        }

        public Builder ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this;
        }

        @Override
        public ScriptField build() {
            return new ScriptField(this);
        }
    }
}

