/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.elasticsearch._core.mget.Hit;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class MgetResponse<TDocument>
implements JsonpSerializable {
    private final List<Hit<TDocument>> docs;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public MgetResponse(Builder<TDocument> builder) {
        this.docs = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).docs, "docs");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public MgetResponse(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public List<Hit<TDocument>> docs() {
        return this.docs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("docs");
        generator.writeStartArray();
        for (Hit<TDocument> item0 : this.docs) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public static <TDocument> JsonpDeserializer<MgetResponse<TDocument>> createMgetResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> MgetResponse.setupMgetResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupMgetResponseDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(Hit.createHitDeserializer(tDocumentDeserializer)), "docs", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<MgetResponse<TDocument>> {
        private List<Hit<TDocument>> docs;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> docs(List<Hit<TDocument>> value) {
            this.docs = value;
            return this;
        }

        public Builder<TDocument> docs(Hit<TDocument> ... value) {
            this.docs = Arrays.asList(value);
            return this;
        }

        public Builder<TDocument> addDocs(Hit<TDocument> value) {
            if (this.docs == null) {
                this.docs = new ArrayList<Hit<TDocument>>();
            }
            this.docs.add(value);
            return this;
        }

        public Builder<TDocument> docs(Function<Hit.Builder<TDocument>, ObjectBuilder<Hit<TDocument>>> fn) {
            return this.docs(fn.apply(new Hit.Builder()).build());
        }

        public Builder<TDocument> addDocs(Function<Hit.Builder<TDocument>, ObjectBuilder<Hit<TDocument>>> fn) {
            return this.addDocs(fn.apply(new Hit.Builder()).build());
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public MgetResponse<TDocument> build() {
            return new MgetResponse(this);
        }
    }
}

