/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._core.MgetResponse;
import co.elastic.clients.elasticsearch._core.mget.Operation;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MgetRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String index;
    @Nullable
    private final String type;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean realtime;
    @Nullable
    private final Boolean refresh;
    @Nullable
    private final String routing;
    @Nullable
    private final JsonValue source;
    @Nullable
    private final List<String> sourceExcludes;
    @Nullable
    private final List<String> sourceIncludes;
    @Nullable
    private final List<String> storedFields;
    @Nullable
    private final List<Operation> docs;
    @Nullable
    private final List<String> ids;
    public static final JsonpDeserializer<MgetRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MgetRequest::setupMgetRequestDeserializer, Builder::build);
    private static final SimpleEndpoint<MgetRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        if (request.index() != null) {
            propsSet |= 1;
        }
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_mget");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_mget");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/_mget");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.realtime != null) {
            params.put("realtime", String.valueOf(request.realtime));
        }
        if (request.refresh != null) {
            params.put("refresh", String.valueOf(request.refresh));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.source != null) {
            params.put("_source", JsonpUtils.toString(request.source));
        }
        if (request.sourceExcludes != null) {
            params.put("_source_excludes", request.sourceExcludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.sourceIncludes != null) {
            params.put("_source_includes", request.sourceIncludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.storedFields != null) {
            params.put("stored_fields", request.storedFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    public MgetRequest(Builder builder) {
        this.index = builder.index;
        this.type = builder.type;
        this.preference = builder.preference;
        this.realtime = builder.realtime;
        this.refresh = builder.refresh;
        this.routing = builder.routing;
        this.source = builder.source;
        this.sourceExcludes = ModelTypeHelper.unmodifiable(builder.sourceExcludes);
        this.sourceIncludes = ModelTypeHelper.unmodifiable(builder.sourceIncludes);
        this.storedFields = ModelTypeHelper.unmodifiable(builder.storedFields);
        this.docs = ModelTypeHelper.unmodifiable(builder.docs);
        this.ids = ModelTypeHelper.unmodifiable(builder.ids);
    }

    public MgetRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public String preference() {
        return this.preference;
    }

    @Nullable
    public Boolean realtime() {
        return this.realtime;
    }

    @Nullable
    public Boolean refresh() {
        return this.refresh;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public JsonValue source() {
        return this.source;
    }

    @Nullable
    public List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    @Nullable
    public List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    @Nullable
    public List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public List<Operation> docs() {
        return this.docs;
    }

    @Nullable
    public List<String> ids() {
        return this.ids;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.docs != null) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (Operation operation : this.docs) {
                operation.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ids != null) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String string : this.ids) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupMgetRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(Operation._DESERIALIZER), "docs", new String[0]);
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids", new String[0]);
    }

    public static <TDocument> Endpoint<MgetRequest, MgetResponse<TDocument>, ElasticsearchError> createMgetEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(MgetResponse.createMgetResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<MgetRequest> {
        @Nullable
        private String index;
        @Nullable
        private String type;
        @Nullable
        private String preference;
        @Nullable
        private Boolean realtime;
        @Nullable
        private Boolean refresh;
        @Nullable
        private String routing;
        @Nullable
        private JsonValue source;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private List<Operation> docs;
        @Nullable
        private List<String> ids;

        public Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public Builder realtime(@Nullable Boolean value) {
            this.realtime = value;
            return this;
        }

        public Builder refresh(@Nullable Boolean value) {
            this.refresh = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder source(@Nullable JsonValue value) {
            this.source = value;
            return this;
        }

        public Builder sourceExcludes(@Nullable List<String> value) {
            this.sourceExcludes = value;
            return this;
        }

        public Builder sourceExcludes(String ... value) {
            this.sourceExcludes = Arrays.asList(value);
            return this;
        }

        public Builder addSourceExcludes(String value) {
            if (this.sourceExcludes == null) {
                this.sourceExcludes = new ArrayList<String>();
            }
            this.sourceExcludes.add(value);
            return this;
        }

        public Builder sourceIncludes(@Nullable List<String> value) {
            this.sourceIncludes = value;
            return this;
        }

        public Builder sourceIncludes(String ... value) {
            this.sourceIncludes = Arrays.asList(value);
            return this;
        }

        public Builder addSourceIncludes(String value) {
            if (this.sourceIncludes == null) {
                this.sourceIncludes = new ArrayList<String>();
            }
            this.sourceIncludes.add(value);
            return this;
        }

        public Builder storedFields(@Nullable List<String> value) {
            this.storedFields = value;
            return this;
        }

        public Builder storedFields(String ... value) {
            this.storedFields = Arrays.asList(value);
            return this;
        }

        public Builder addStoredFields(String value) {
            if (this.storedFields == null) {
                this.storedFields = new ArrayList<String>();
            }
            this.storedFields.add(value);
            return this;
        }

        public Builder docs(@Nullable List<Operation> value) {
            this.docs = value;
            return this;
        }

        public Builder docs(Operation ... value) {
            this.docs = Arrays.asList(value);
            return this;
        }

        public Builder addDocs(Operation value) {
            if (this.docs == null) {
                this.docs = new ArrayList<Operation>();
            }
            this.docs.add(value);
            return this;
        }

        public Builder docs(Function<Operation.Builder, ObjectBuilder<Operation>> fn) {
            return this.docs(fn.apply(new Operation.Builder()).build());
        }

        public Builder addDocs(Function<Operation.Builder, ObjectBuilder<Operation>> fn) {
            return this.addDocs(fn.apply(new Operation.Builder()).build());
        }

        public Builder ids(@Nullable List<String> value) {
            this.ids = value;
            return this;
        }

        public Builder ids(String ... value) {
            this.ids = Arrays.asList(value);
            return this;
        }

        public Builder addIds(String value) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>();
            }
            this.ids.add(value);
            return this;
        }

        @Override
        public MgetRequest build() {
            return new MgetRequest(this);
        }
    }
}

