/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.elasticsearch._core.field_caps.FieldCapability;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class FieldCapsResponse
implements JsonpSerializable {
    private final List<String> indices;
    private final Map<String, Map<String, FieldCapability>> fields;
    public static final JsonpDeserializer<FieldCapsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldCapsResponse::setupFieldCapsResponseDeserializer, Builder::build);

    public FieldCapsResponse(Builder builder) {
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.fields = ModelTypeHelper.unmodifiableNonNull(builder.fields, "fields");
    }

    public FieldCapsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> indices() {
        return this.indices;
    }

    public Map<String, Map<String, FieldCapability>> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String string : this.indices) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("fields");
        generator.writeStartObject();
        for (Map.Entry entry : this.fields.entrySet()) {
            generator.writeKey((String)entry.getKey());
            generator.writeStartObject();
            for (Map.Entry item1 : ((Map)entry.getValue()).entrySet()) {
                generator.writeKey((String)item1.getKey());
                ((FieldCapability)item1.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    protected static void setupFieldCapsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(FieldCapability._DESERIALIZER)), "fields", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldCapsResponse> {
        private List<String> indices;
        private Map<String, Map<String, FieldCapability>> fields;

        public Builder indices(List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder fields(Map<String, Map<String, FieldCapability>> value) {
            this.fields = value;
            return this;
        }

        public Builder putFields(String key, Map<String, FieldCapability> value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, Map<String, FieldCapability>>();
            }
            this.fields.put(key, value);
            return this;
        }

        @Override
        public FieldCapsResponse build() {
            return new FieldCapsResponse(this);
        }
    }
}

