/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.elasticsearch._core.explain.ExplanationDetail;
import co.elastic.clients.elasticsearch._types.InlineGet;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ExplainResponse<TDocument>
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final String type;
    private final String id;
    private final boolean matched;
    @Nullable
    private final ExplanationDetail explanation;
    @Nullable
    private final InlineGet<TDocument> get;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public ExplainResponse(Builder<TDocument> builder) {
        this.index = Objects.requireNonNull(((Builder)builder).index, "_index");
        this.type = ((Builder)builder).type;
        this.id = Objects.requireNonNull(((Builder)builder).id, "_id");
        this.matched = Objects.requireNonNull(((Builder)builder).matched, "matched");
        this.explanation = ((Builder)builder).explanation;
        this.get = ((Builder)builder).get;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public ExplainResponse(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public boolean matched() {
        return this.matched;
    }

    @Nullable
    public ExplanationDetail explanation() {
        return this.explanation;
    }

    @Nullable
    public InlineGet<TDocument> get() {
        return this.get;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_index");
        generator.write(this.index);
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("matched");
        generator.write(this.matched);
        if (this.explanation != null) {
            generator.writeKey("explanation");
            this.explanation.serialize(generator, mapper);
        }
        if (this.get != null) {
            generator.writeKey("get");
            this.get.serialize(generator, mapper);
        }
    }

    public static <TDocument> JsonpDeserializer<ExplainResponse<TDocument>> createExplainResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> ExplainResponse.setupExplainResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupExplainResponseDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::matched, JsonpDeserializer.booleanDeserializer(), "matched", new String[0]);
        op.add(Builder::explanation, ExplanationDetail._DESERIALIZER, "explanation", new String[0]);
        op.add(Builder::get, InlineGet.createInlineGetDeserializer(tDocumentDeserializer), "get", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<ExplainResponse<TDocument>> {
        private String index;
        @Nullable
        private String type;
        private String id;
        private Boolean matched;
        @Nullable
        private ExplanationDetail explanation;
        @Nullable
        private InlineGet<TDocument> get;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public Builder<TDocument> type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder<TDocument> id(String value) {
            this.id = value;
            return this;
        }

        public Builder<TDocument> matched(boolean value) {
            this.matched = value;
            return this;
        }

        public Builder<TDocument> explanation(@Nullable ExplanationDetail value) {
            this.explanation = value;
            return this;
        }

        public Builder<TDocument> explanation(Function<ExplanationDetail.Builder, ObjectBuilder<ExplanationDetail>> fn) {
            return this.explanation(fn.apply(new ExplanationDetail.Builder()).build());
        }

        public Builder<TDocument> get(@Nullable InlineGet<TDocument> value) {
            this.get = value;
            return this;
        }

        public Builder<TDocument> get(Function<InlineGet.Builder<TDocument>, ObjectBuilder<InlineGet<TDocument>>> fn) {
            return this.get(fn.apply(new InlineGet.Builder()).build());
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public ExplainResponse<TDocument> build() {
            return new ExplainResponse(this);
        }
    }
}

