/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.attach.UserRegistry;
import java.util.Locale;
import java.util.Properties;
import net.bytebuddy.agent.ByteBuddyAgent;

class JvmInfo {
    public static final String CURRENT_PID = ByteBuddyAgent.ProcessProvider.ForCurrentVm.INSTANCE.resolve();
    private final String pid;
    private final String userName;
    private final String mainClass;
    private final String vmArgs;
    private final String javaVersion;
    private final String mainArgs;
    private boolean alreadyAttached;

    JvmInfo(String pid, String userName, Properties properties) {
        this.pid = pid;
        this.userName = userName;
        String sunJavaCommand = properties.getProperty("sun.java.command");
        if (sunJavaCommand != null && !sunJavaCommand.isEmpty()) {
            int firstSpace = sunJavaCommand.indexOf(32);
            if (firstSpace > 0) {
                this.mainClass = sunJavaCommand.substring(0, firstSpace);
                this.mainArgs = sunJavaCommand.substring(firstSpace + 1);
            } else {
                this.mainClass = sunJavaCommand;
                this.mainArgs = null;
            }
        } else {
            this.mainClass = null;
            this.mainArgs = null;
        }
        this.vmArgs = properties.getProperty("sun.jvm.args");
        this.javaVersion = properties.getProperty("java.version");
        this.alreadyAttached = properties.containsKey("ElasticApm.attached");
    }

    public static JvmInfo withCurrentUser(String pid, Properties properties) {
        return JvmInfo.of(pid, UserRegistry.getCurrentUserName(), properties);
    }

    public static JvmInfo of(String pid, String userName, Properties properties) {
        return new JvmInfo(pid, userName, properties);
    }

    public static boolean isJ9() {
        return System.getProperty("java.vm.name", "").toUpperCase(Locale.US).contains("J9");
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean listVmArgs) {
        return this.getPid() + ' ' + this.mainClass + (listVmArgs ? ' ' + this.vmArgs : "");
    }

    public String getPid() {
        return this.pid;
    }

    public boolean isCurrentVM() {
        return this.getPid().equals(CURRENT_PID);
    }

    public String getUserName() {
        return this.userName;
    }

    public UserRegistry.User getUser(UserRegistry registry) {
        return registry.get(this.userName);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getVmArgs() {
        return this.vmArgs;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public boolean isVersionSupported() {
        if (this.javaVersion.startsWith("1.")) {
            return Character.digit(this.javaVersion.charAt(2), 10) >= 7;
        }
        return true;
    }

    public boolean isAlreadyAttached() {
        return this.alreadyAttached;
    }

    public boolean isCurrentUser() {
        return this.userName.equals(UserRegistry.getCurrentUserName());
    }
}

