/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.attach.CachedAttachmentProvider;
import java.util.ArrayList;
import java.util.Arrays;
import net.bytebuddy.agent.ByteBuddyAgent;

public class ElasticAttachmentProvider {
    private static ByteBuddyAgent.AttachmentProvider provider;

    public static synchronized void init(boolean useEmulatedAttach) {
        if (provider != null) {
            throw new IllegalStateException("ElasticAttachmentProvider.init() should only be called once");
        }
        ArrayList<ByteBuddyAgent.AttachmentProvider> providers = new ArrayList<ByteBuddyAgent.AttachmentProvider>();
        if (useEmulatedAttach) {
            providers.add(ByteBuddyAgent.AttachmentProvider.ForEmulatedAttachment.INSTANCE);
        }
        providers.addAll(Arrays.asList(ByteBuddyAgent.AttachmentProvider.ForModularizedVm.INSTANCE, ByteBuddyAgent.AttachmentProvider.ForJ9Vm.INSTANCE, new CachedAttachmentProvider(ByteBuddyAgent.AttachmentProvider.ForStandardToolsJarVm.JVM_ROOT), new CachedAttachmentProvider(ByteBuddyAgent.AttachmentProvider.ForStandardToolsJarVm.JDK_ROOT), new CachedAttachmentProvider(ByteBuddyAgent.AttachmentProvider.ForStandardToolsJarVm.MACINTOSH), new CachedAttachmentProvider(ByteBuddyAgent.AttachmentProvider.ForUserDefinedToolsJar.INSTANCE)));
        provider = new ByteBuddyAgent.AttachmentProvider.Compound(providers);
    }

    public static synchronized ByteBuddyAgent.AttachmentProvider get() {
        if (provider == null) {
            ElasticAttachmentProvider.init(true);
        }
        return provider;
    }
}

