/*-
 * #%L
 * Elastic APM Java agent
 * %%
 * Copyright (C) 2018 - 2019 Elastic and contributors
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package co.elastic.apm.api;

/**
 * Used to extract the first header with a specific header name.
 * <p>
 * Can be implemented as a lambda in Java 8 and as an anonymous inner class in Java 7.
 * </p>
 */
public interface HeaderExtractor {

    /**
     * Returns the value of the provided header name
     *
     * @param headerName the name of the header to extract
     * @return the value of the provided header name
     */
    String getFirstHeader(String headerName);
}
