/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionAware;
import java.util.ArrayList;
import java.util.Collection;

public final class TransactionAwares {
    private TransactionAwares() {
    }

    public static TransactionAware of(Collection<TransactionAware> transactionAwares) {
        if (transactionAwares.size() == 1) {
            return transactionAwares.iterator().next();
        }
        TransactionAwareCollection result = new TransactionAwareCollection();
        result.addAll(transactionAwares);
        return result;
    }

    private static class TransactionAwareCollection
    extends ArrayList<TransactionAware>
    implements TransactionAware {
        private TransactionAwareCollection() {
        }

        @Override
        public void startTx(Transaction tx) {
            for (TransactionAware txAware : this) {
                txAware.startTx(tx);
            }
        }

        @Override
        public void updateTx(Transaction tx) {
            for (TransactionAware txAware : this) {
                txAware.updateTx(tx);
            }
        }

        @Override
        public Collection<byte[]> getTxChanges() {
            ArrayList<byte[]> changes = new ArrayList<byte[]>();
            for (TransactionAware txAware : this) {
                changes.addAll(txAware.getTxChanges());
            }
            return changes;
        }

        @Override
        public boolean commitTx() throws Exception {
            boolean success = true;
            for (TransactionAware txAware : this) {
                success = success && txAware.commitTx();
            }
            return success;
        }

        @Override
        public void postTxCommit() {
            for (TransactionAware txAware : this) {
                txAware.postTxCommit();
            }
        }

        @Override
        public boolean rollbackTx() throws Exception {
            boolean success = true;
            for (TransactionAware txAware : this) {
                success = success && txAware.rollbackTx();
            }
            return success;
        }

        @Override
        public String getTransactionAwareName() {
            StringBuilder sb = new StringBuilder("{");
            for (TransactionAware txAware : this) {
                sb.append(txAware.getTransactionAwareName()).append(",");
            }
            sb.replace(sb.length() - 1, sb.length() - 1, "}");
            return sb.toString();
        }
    }
}

