/*
 * Decompiled with CFR 0.152.
 */
package co.cask.format.text.input;

import co.cask.cdap.api.annotation.Description;
import co.cask.cdap.api.annotation.Name;
import co.cask.cdap.api.annotation.Plugin;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.plugin.PluginClass;
import co.cask.format.text.input.CombineTextInputFormat;
import co.cask.hydrator.format.input.PathTrackingConfig;
import co.cask.hydrator.format.input.PathTrackingInputFormatProvider;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;

@Plugin(type="inputformat")
@Name(value="text")
@Description(value="Plugin for reading files in text format.")
public class TextInputFormatProvider
extends PathTrackingInputFormatProvider<TextConfig> {
    static final String NAME = "text";
    static final String DESC = "Plugin for reading files in text format.";
    public static final PluginClass PLUGIN_CLASS = new PluginClass("inputformat", "text", "Plugin for reading files in text format.", TextInputFormatProvider.class.getName(), "conf", PathTrackingConfig.FIELDS);

    public TextInputFormatProvider(TextConfig conf) {
        super((PathTrackingConfig)conf);
    }

    public String getInputFormatClassName() {
        return CombineTextInputFormat.class.getName();
    }

    protected void validate() {
        Schema.Type bodyType;
        Schema.Field bodyField;
        if (((TextConfig)this.conf).containsMacro("schema")) {
            return;
        }
        String pathField = ((TextConfig)this.conf).getPathField();
        Schema schema = ((TextConfig)this.conf).getSchema();
        Schema.Field offsetField = schema.getField("offset");
        if (offsetField != null) {
            Schema.Type offsetType;
            Schema offsetSchema = offsetField.getSchema();
            Schema.Type type = offsetType = offsetSchema.isNullable() ? offsetSchema.getNonNullable().getType() : offsetSchema.getType();
            if (offsetType != Schema.Type.LONG) {
                throw new IllegalArgumentException(String.format("The 'offset' field must be of type 'long', but found '%s'", offsetType.name().toLowerCase()));
            }
        }
        if ((bodyField = schema.getField("body")) == null) {
            throw new IllegalArgumentException("The schema for the 'text' format must have a field named 'body'");
        }
        Schema bodySchema = bodyField.getSchema();
        Schema.Type type = bodyType = bodySchema.isNullable() ? bodySchema.getNonNullable().getType() : bodySchema.getType();
        if (bodyType != Schema.Type.STRING) {
            throw new IllegalArgumentException(String.format("The 'body' field must be of type 'string', but found '%s'", bodyType.name().toLowerCase()));
        }
        boolean expectOffset = schema.getField("offset") != null;
        boolean expectPath = pathField != null;
        int numExpectedFields = 1;
        if (expectOffset) {
            ++numExpectedFields;
        }
        if (expectPath) {
            ++numExpectedFields;
        }
        int maxExpectedFields = pathField == null ? 2 : 3;
        int numFields = schema.getFields().size();
        if (numFields > numExpectedFields) {
            String expectedFields = expectOffset && expectPath ? String.format("'offset', 'body', and '%s' fields", pathField) : (expectOffset ? "'offset' and 'body' fields" : (expectPath ? String.format("'body' and '%s' fields", pathField) : "'body' field"));
            int numExtraFields = numFields - maxExpectedFields;
            throw new IllegalArgumentException(String.format("The schema for the 'text' format must only contain the %s, but found %d other field%s", expectedFields, numExtraFields, numExtraFields > 1 ? "s" : ""));
        }
    }

    public static Schema getDefaultSchema(@Nullable String pathField) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(Schema.Field.of((String)"offset", (Schema)Schema.of((Schema.Type)Schema.Type.LONG)));
        fields.add(Schema.Field.of((String)"body", (Schema)Schema.of((Schema.Type)Schema.Type.STRING)));
        if (pathField != null && !pathField.isEmpty()) {
            fields.add(Schema.Field.of((String)pathField, (Schema)Schema.of((Schema.Type)Schema.Type.STRING)));
        }
        return Schema.recordOf((String)"textfile", fields);
    }

    public static class TextConfig
    extends PathTrackingConfig {
        public Schema getSchema() {
            if (this.containsMacro("schema")) {
                throw new IllegalStateException("schema should not be checked until macros are evaluated.");
            }
            if (this.schema == null) {
                return TextInputFormatProvider.getDefaultSchema(this.pathField);
            }
            try {
                return Schema.parseJson((String)this.schema);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to parse schema: " + e.getMessage(), e);
            }
        }
    }
}

