/*
 * Decompiled with CFR 0.152.
 */
package co.cask.format.text.input;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.hydrator.format.input.PathTrackingInputFormat;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;

public class PathTrackingTextInputFormat
extends PathTrackingInputFormat {
    protected RecordReader<NullWritable, StructuredRecord.Builder> createRecordReader(FileSplit split, TaskAttemptContext context, @Nullable String pathField, Schema schema) {
        RecordReader delegate = new TextInputFormat().createRecordReader((InputSplit)split, context);
        String header = context.getConfiguration().get("combine.path.tracking.header");
        return new TextRecordReader((RecordReader<LongWritable, Text>)delegate, schema, header);
    }

    static class TextRecordReader
    extends RecordReader<NullWritable, StructuredRecord.Builder> {
        private final RecordReader<LongWritable, Text> delegate;
        private final Schema schema;
        private final String header;
        private final boolean setOffset;
        private boolean emittedHeader;

        TextRecordReader(RecordReader<LongWritable, Text> delegate, Schema schema, @Nullable String header) {
            this.delegate = delegate;
            this.schema = schema;
            this.header = header;
            this.setOffset = schema.getField("offset") != null;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.delegate.initialize(split, context);
            this.emittedHeader = false;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.header != null && !this.emittedHeader) {
                return true;
            }
            if (this.delegate.nextKeyValue()) {
                if (this.emittedHeader && ((LongWritable)this.delegate.getCurrentKey()).get() == 0L) {
                    return this.delegate.nextKeyValue();
                }
                return true;
            }
            return false;
        }

        public NullWritable getCurrentKey() {
            return NullWritable.get();
        }

        public StructuredRecord.Builder getCurrentValue() throws IOException, InterruptedException {
            StructuredRecord.Builder recordBuilder = StructuredRecord.builder((Schema)this.schema);
            if (this.header != null && !this.emittedHeader) {
                this.emittedHeader = true;
                if (this.setOffset) {
                    recordBuilder.set("offset", (Object)0L);
                }
                recordBuilder.set("body", (Object)this.header);
            } else {
                if (this.setOffset) {
                    recordBuilder.set("offset", (Object)((LongWritable)this.delegate.getCurrentKey()).get());
                }
                recordBuilder.set("body", (Object)((Text)this.delegate.getCurrentValue()).toString());
            }
            return recordBuilder;
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.delegate.getProgress();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

