/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.chatroom.whitelist;

import io.rong.RongCloud;
import io.rong.models.response.ChatroomWhitelistMsgResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Messages {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "chatroom/whitelist/message";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Messages(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public ResponseResult add(String[] objectNames) throws Exception {
        String errMsg = CommonUtil.checkParam("type", objectNames, PATH, "add");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objectNames.length; ++i) {
            String child = objectNames[i];
            sb.append("&objectnames=").append(URLEncoder.encode(child, UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/whitelist/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "add", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ResponseResult remove(String[] objectNames) throws Exception {
        String errMsg = CommonUtil.checkParam("type", objectNames, PATH, "remove");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objectNames.length; ++i) {
            String child = objectNames[i];
            sb.append("&objectnames=").append(URLEncoder.encode(child, UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/whitelist/delete.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "remove", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ChatroomWhitelistMsgResult getList() throws Exception {
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/whitelist/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter("", conn, this.rongCloud.getConfig());
        return (ChatroomWhitelistMsgResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "getList", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ChatroomWhitelistMsgResult.class);
    }
}

