/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.chatroom.entry;

import io.rong.RongCloud;
import io.rong.models.chatroom.ChatroomEntryModel;
import io.rong.models.response.ChatroomEntryListResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;

public class ChatroomEntry {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "chatroom/entry";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public ChatroomEntry(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public ChatroomEntry(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
    }

    public ResponseResult set(ChatroomEntryModel model) throws Exception {
        String body;
        String message = CommonUtil.checkFiled(model, PATH, "set");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(model.chatroomId, UTF8));
        sb.append("&userId=").append(URLEncoder.encode(model.userId.toString(), UTF8));
        sb.append("&key=").append(URLEncoder.encode(model.key, UTF8));
        sb.append("&value=").append(URLEncoder.encode(model.value, UTF8));
        sb.append("&autoDelete=").append(model.autoDelete);
        if (StringUtils.isNotBlank((CharSequence)model.objectName)) {
            sb.append("&objectName=").append(URLEncoder.encode(model.objectName, UTF8));
        }
        if (StringUtils.isNotBlank((CharSequence)model.content)) {
            sb.append("&content=").append(URLEncoder.encode(model.content, UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/entry/set.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "set", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ResponseResult remove(ChatroomEntryModel model) throws Exception {
        String body;
        String message = CommonUtil.checkFiled(model, PATH, "remove");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(model.chatroomId, UTF8));
        sb.append("&userId=").append(URLEncoder.encode(model.userId, UTF8));
        sb.append("&key=").append(URLEncoder.encode(model.key, UTF8));
        if (!StringUtils.isBlank((CharSequence)model.objectName)) {
            sb.append("&objectName=").append(URLEncoder.encode(model.objectName, UTF8));
        }
        if (!StringUtils.isBlank((CharSequence)model.content)) {
            sb.append("&content=").append(URLEncoder.encode(model.content, UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/entry/remove.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "remove", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ChatroomEntryListResult query(ChatroomEntryModel model) throws Exception {
        String body;
        String message = CommonUtil.checkFiled(model, PATH, "query");
        if (null != message) {
            return (ChatroomEntryListResult)GsonUtil.fromJson(message, ChatroomEntryListResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(model.chatroomId, UTF8));
        if (null != model.keys && model.keys.length > 0) {
            for (String key : model.keys) {
                sb.append("&keys=").append(URLEncoder.encode(key, UTF8));
            }
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/entry/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ChatroomEntryListResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "query", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ChatroomEntryListResult.class);
    }
}

