/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.notification.PlatformNotification;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class WinphoneNotification
extends PlatformNotification {
    private static final String NOTIFICATION_WINPHONE = "winphone";
    private static final String TITLE = "title";
    private static final String _OPEN_PAGE = "_open_page";
    private final String title;
    private final String openPage;

    private WinphoneNotification(Object alert, String title, String openPage, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras, Map<String, JsonPrimitive> customData) {
        super(alert, extras, numberExtras, booleanExtras, jsonExtras, customData);
        this.title = title;
        this.openPage = openPage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static WinphoneNotification alert(String alert) {
        return WinphoneNotification.newBuilder().setAlert(alert).build();
    }

    @Override
    public String getPlatform() {
        return NOTIFICATION_WINPHONE;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = super.toJSON().getAsJsonObject();
        if (null != this.title) {
            json.add(TITLE, (JsonElement)new JsonPrimitive(this.title));
        }
        if (null != this.openPage) {
            json.add(_OPEN_PAGE, (JsonElement)new JsonPrimitive(this.openPage));
        }
        return json;
    }

    public static class Builder
    extends PlatformNotification.Builder<WinphoneNotification, Builder> {
        private String title;
        private String openPage;

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setOpenPage(String openPage) {
            this.openPage = openPage;
            return this;
        }

        @Override
        public Builder setAlert(Object alert) {
            this.alert = alert;
            return this;
        }

        @Override
        public WinphoneNotification build() {
            return new WinphoneNotification(this.alert, this.title, this.openPage, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder, this.customData);
        }
    }
}

