/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.pubsub;

import cn.jmicro.api.JMicroContext;
import cn.jmicro.api.annotation.Component;
import cn.jmicro.api.annotation.Inject;
import cn.jmicro.api.annotation.SMethod;
import cn.jmicro.api.annotation.Service;
import cn.jmicro.api.internal.pubsub.IInternalSubRpc;
import cn.jmicro.api.profile.ProfileManager;
import cn.jmicro.api.pubsub.IPubSubClientService;
import cn.jmicro.api.pubsub.PSData;
import cn.jmicro.api.pubsub.PubSubManager;
import cn.jmicro.api.security.ActInfo;

@Component
@Service(version="0.0.1", external=true, debugMode=0, showFront=false)
public class PubSubClientServiceImpl
implements IPubSubClientService {
    @Inject
    private PubSubManager psMng;
    @Inject(required=false)
    private IInternalSubRpc psServer;
    @Inject
    private ProfileManager pm;

    @SMethod(perType=true, needLogin=true, maxSpeed=50, maxPacketSize=81920)
    public int publishMutilItems(PSData[] items) {
        if (items.length == 0 || items.length > 10) {
            return -8;
        }
        ActInfo ai = JMicroContext.get().getAccount();
        if (((Boolean)this.pm.getVal(Integer.valueOf(ai.getId()), "pubsub", "needPersist", (Object)false, Boolean.class)).booleanValue()) {
            this.psMng.persist2Db(ai.getId(), items);
        }
        return this.psServer.publishItems(items[0].getTopic(), items);
    }

    @SMethod(perType=false, needLogin=true, maxSpeed=50, maxPacketSize=8192)
    public int publishOneItem(PSData item) {
        ActInfo ai = JMicroContext.get().getAccount();
        if (item.isPersist() && ((Boolean)this.pm.getVal(Integer.valueOf(item.getSrcClientId()), "pubsub", "needPersist", (Object)false, Boolean.class)).booleanValue()) {
            this.psMng.persit2Db(ai.getId(), item);
        }
        return this.psServer.publishItem(item);
    }
}

