/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.protocol;

import cn.iflow.sdk.types.protocol.AgentInfo;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AgentInfo", generator="Immutables")
@Immutable
public final class ImmutableAgentInfo
implements AgentInfo {
    private final String taskId;
    private final String instanceId;
    private final int index;
    private final long timestamp;

    private ImmutableAgentInfo(String taskId, String instanceId, int index, long timestamp) {
        this.taskId = taskId;
        this.instanceId = instanceId;
        this.index = index;
        this.timestamp = timestamp;
    }

    @Override
    public String taskId() {
        return this.taskId;
    }

    @Override
    public String instanceId() {
        return this.instanceId;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    public final ImmutableAgentInfo withTaskId(String value) {
        String newValue = Objects.requireNonNull(value, "taskId");
        if (this.taskId.equals(newValue)) {
            return this;
        }
        return new ImmutableAgentInfo(newValue, this.instanceId, this.index, this.timestamp);
    }

    public final ImmutableAgentInfo withInstanceId(String value) {
        String newValue = Objects.requireNonNull(value, "instanceId");
        if (this.instanceId.equals(newValue)) {
            return this;
        }
        return new ImmutableAgentInfo(this.taskId, newValue, this.index, this.timestamp);
    }

    public final ImmutableAgentInfo withIndex(int value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutableAgentInfo(this.taskId, this.instanceId, value, this.timestamp);
    }

    public final ImmutableAgentInfo withTimestamp(long value) {
        if (this.timestamp == value) {
            return this;
        }
        return new ImmutableAgentInfo(this.taskId, this.instanceId, this.index, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAgentInfo && this.equalTo(0, (ImmutableAgentInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableAgentInfo another) {
        return this.taskId.equals(another.taskId) && this.instanceId.equals(another.instanceId) && this.index == another.index && this.timestamp == another.timestamp;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.taskId.hashCode();
        h += (h << 5) + this.instanceId.hashCode();
        h += (h << 5) + this.index;
        h += (h << 5) + Long.hashCode(this.timestamp);
        return h;
    }

    public String toString() {
        return "AgentInfo{taskId=" + this.taskId + ", instanceId=" + this.instanceId + ", index=" + this.index + ", timestamp=" + this.timestamp + "}";
    }

    public static ImmutableAgentInfo copyOf(AgentInfo instance) {
        if (instance instanceof ImmutableAgentInfo) {
            return (ImmutableAgentInfo)instance;
        }
        return ImmutableAgentInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AgentInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TASK_ID = 1L;
        private static final long INIT_BIT_INSTANCE_ID = 2L;
        private static final long INIT_BIT_INDEX = 4L;
        private static final long INIT_BIT_TIMESTAMP = 8L;
        private long initBits = 15L;
        @Nullable
        private String taskId;
        @Nullable
        private String instanceId;
        private int index;
        private long timestamp;

        private Builder() {
        }

        public final Builder from(AgentInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.taskId(instance.taskId());
            this.instanceId(instance.instanceId());
            this.index(instance.index());
            this.timestamp(instance.timestamp());
            return this;
        }

        public final Builder taskId(String taskId) {
            this.taskId = Objects.requireNonNull(taskId, "taskId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder instanceId(String instanceId) {
            this.instanceId = Objects.requireNonNull(instanceId, "instanceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder index(int index) {
            this.index = index;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableAgentInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAgentInfo(this.taskId, this.instanceId, this.index, this.timestamp);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("taskId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("instanceId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("timestamp");
            }
            return "Cannot build AgentInfo, some of required attributes are not set " + attributes;
        }
    }
}

