/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.query;

import cn.iflow.sdk.core.IFlowClient;
import cn.iflow.sdk.exceptions.IFlowException;
import cn.iflow.sdk.types.config.IFlowOptions;
import cn.iflow.sdk.types.messages.ErrorMessage;
import cn.iflow.sdk.types.messages.Message;
import cn.iflow.sdk.types.messages.TaskFinishMessage;
import java.time.Duration;
import java.util.List;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class IFlowQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IFlowQuery.class);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(5L);

    private IFlowQuery() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static List<Message> querySync(String prompt) throws IFlowException {
        return IFlowQuery.querySync(prompt, DEFAULT_TIMEOUT);
    }

    public static List<Message> querySync(String prompt, Duration timeout) throws IFlowException {
        if (prompt == null || prompt.isBlank()) {
            throw new IFlowException("Prompt cannot be null or empty");
        }
        log.debug("Starting synchronous query with prompt: {}, timeout: {}", (Object)prompt, (Object)timeout);
        try {
            List result = (List)IFlowQuery.query(prompt).block(timeout);
            log.debug("Synchronous query completed successfully, received {} messages", (Object)(result != null ? result.size() : 0));
            return result;
        }
        catch (Exception e) {
            log.error("Synchronous query failed for prompt: {}", (Object)prompt, (Object)e);
            if (e instanceof IFlowException) {
                throw (IFlowException)e;
            }
            throw new IFlowException("Query failed", e);
        }
    }

    public static Mono<List<Message>> query(String prompt) {
        log.debug("Starting asynchronous query with default options, prompt: {}", (Object)prompt);
        return IFlowQuery.query(prompt, IFlowOptions.getDefault());
    }

    public static Mono<List<Message>> query(String prompt, IFlowOptions options) {
        log.debug("Starting asynchronous query with prompt: {}, options: {}", (Object)prompt, (Object)options);
        return Mono.usingWhen((Publisher)Mono.fromCallable(() -> {
            log.debug("Creating IFlow client");
            return IFlowClient.create(options);
        }), client -> {
            log.debug("Connecting to IFlow and sending message");
            return client.connect().then(client.sendMessage(prompt)).then(client.receiveMessages().takeUntil(message -> message instanceof TaskFinishMessage || message instanceof ErrorMessage).collectList()).doOnSuccess(messages -> log.debug("Query completed successfully, received {} messages", (Object)messages.size())).doOnError(error -> log.error("Query failed for prompt: {}", (Object)prompt, error));
        }, client -> {
            log.debug("Closing IFlow client");
            return Mono.fromRunnable(() -> {
                try {
                    client.close();
                }
                catch (Exception e) {
                    log.warn("Error closing client during cleanup", (Throwable)e);
                }
            });
        });
    }

    public static Flux<Message> queryStream(String prompt) {
        log.debug("Starting streaming query with default options, prompt: {}", (Object)prompt);
        return IFlowQuery.queryStream(prompt, IFlowOptions.getDefault());
    }

    public static Flux<Message> queryStream(String prompt, IFlowOptions options) {
        log.debug("Starting streaming query with prompt: {}, options: {}", (Object)prompt, (Object)options);
        return Flux.usingWhen((Publisher)Mono.fromCallable(() -> {
            log.debug("Creating IFlow client for streaming");
            return IFlowClient.create(options);
        }), client -> {
            log.debug("Connecting to IFlow and starting message stream");
            return client.connect().then(client.sendMessage(prompt)).thenMany((Publisher)client.receiveMessages().takeUntil(message -> message instanceof TaskFinishMessage || message instanceof ErrorMessage)).doOnNext(message -> log.trace("Received message: {}", (Object)message.getClass().getSimpleName())).doOnComplete(() -> log.debug("Streaming query completed")).doOnError(error -> log.error("Streaming query failed for prompt: {}", (Object)prompt, error));
        }, client -> {
            log.debug("Closing IFlow client after streaming");
            return Mono.fromRunnable(() -> {
                try {
                    client.close();
                }
                catch (Exception e) {
                    log.warn("Error closing client during streaming cleanup", (Throwable)e);
                }
            });
        });
    }
}

