/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.protocol;

import cn.iflow.sdk.exceptions.AuthenticationException;
import cn.iflow.sdk.exceptions.IFlowException;
import cn.iflow.sdk.exceptions.ProtocolException;
import cn.iflow.sdk.protocol.AgentMethod;
import cn.iflow.sdk.transport.WebSocketTransport;
import cn.iflow.sdk.types.config.CommandConfig;
import cn.iflow.sdk.types.config.CreateAgentConfig;
import cn.iflow.sdk.types.config.HookEventConfig;
import cn.iflow.sdk.types.config.McpServerConfig;
import cn.iflow.sdk.types.config.SessionSettings;
import cn.iflow.sdk.types.content.Content;
import cn.iflow.sdk.types.enums.HookEventType;
import cn.iflow.sdk.types.protocol.AuthMethodInfo;
import cn.iflow.sdk.types.protocol.notifications.SessionCancelParams;
import cn.iflow.sdk.types.protocol.requests.AuthenticateParams;
import cn.iflow.sdk.types.protocol.requests.FileReadParams;
import cn.iflow.sdk.types.protocol.requests.FileWriteParams;
import cn.iflow.sdk.types.protocol.requests.InitializeParams;
import cn.iflow.sdk.types.protocol.requests.LoadSessionParams;
import cn.iflow.sdk.types.protocol.requests.PermissionRequestParams;
import cn.iflow.sdk.types.protocol.requests.PromptParams;
import cn.iflow.sdk.types.protocol.requests.SessionNewParams;
import cn.iflow.sdk.types.protocol.responses.FileReadResult;
import cn.iflow.sdk.types.protocol.responses.FileWriteResult;
import cn.iflow.sdk.types.protocol.responses.InitializeResult;
import cn.iflow.sdk.types.protocol.responses.PermissionRequestResult;
import cn.iflow.sdk.types.protocol.rpc.JsonRpcRequest;
import cn.iflow.sdk.util.GsonFactory;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class ACPProtocol {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ACPProtocol.class);
    private static final int PROTOCOL_VERSION = 1;
    private final Gson gson;
    private final WebSocketTransport transport;
    private final Function<PermissionRequestParams, Mono<PermissionRequestResult>> permissionCallback;
    private final Function<FileReadParams, Mono<FileReadResult>> fileReadCallback;
    private final Function<FileWriteParams, Mono<FileWriteResult>> FileWriteCallback;
    private volatile boolean initialized = false;
    private volatile InitializeResult initializeResult;
    private volatile boolean authenticated = false;
    private final AtomicInteger requestIdCounter = new AtomicInteger(0);
    private final ConcurrentHashMap<String, MonoSink<JsonElement>> pendingResponseSinks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Mono<JsonElement>> pendingResponses = new ConcurrentHashMap();
    private final Sinks.Many<Map<String, Object>> messageSink = Sinks.many().multicast().onBackpressureBuffer();

    public ACPProtocol(WebSocketTransport transport, Function<PermissionRequestParams, Mono<PermissionRequestResult>> permissionCallback, Function<FileReadParams, Mono<FileReadResult>> fileReadCallback, Function<FileWriteParams, Mono<FileWriteResult>> FileWriteCallback) {
        this.transport = transport;
        this.permissionCallback = permissionCallback;
        this.fileReadCallback = fileReadCallback;
        this.FileWriteCallback = FileWriteCallback;
        this.gson = GsonFactory.getInstance();
    }

    private String nextRequestId() {
        return String.valueOf(this.requestIdCounter.incrementAndGet());
    }

    public Mono<InitializeResult> initialize() {
        return this.initialize(null, null, null, null);
    }

    public Mono<InitializeResult> initialize(List<McpServerConfig> mcpServers, Map<HookEventType, List<HookEventConfig>> hooks, List<CommandConfig> commands, List<CreateAgentConfig> agents) {
        if (this.initialized) {
            log.warn("Protocol already initialized");
            return Mono.just((Object)this.initializeResult);
        }
        return this.transport.connect().then(Mono.fromRunnable(this::startHandleMessages)).then(Mono.defer(() -> {
            InitializeParams.FileSystemCapabilities fsCapabilities = InitializeParams.FileSystemCapabilities.builder().readTextFile(true).writeTextFile(true).build();
            InitializeParams.ClientCapabilities clientCapabilities = InitializeParams.ClientCapabilities.builder().fs(fsCapabilities).build();
            InitializeParams.InitializeParamsBuilder paramsBuilder = InitializeParams.builder().protocolVersion(1).clientCapabilities(clientCapabilities);
            if (mcpServers != null) {
                paramsBuilder.mcpServers(mcpServers);
            }
            if (hooks != null) {
                paramsBuilder.hooks(hooks);
            }
            if (commands != null) {
                paramsBuilder.commands(commands);
            }
            if (agents != null) {
                paramsBuilder.agents(agents);
            }
            InitializeParams params = paramsBuilder.build();
            return this.sendRequest(AgentMethod.INITIALIZE, params).flatMap(requestId -> this.receiveResponse((AgentMethod)AgentMethod.INITIALIZE, (String)requestId));
        })).doOnSuccess(result -> {
            this.initialized = true;
            this.initializeResult = result;
            log.info("Initialized with protocol version: {}", (Object)result.getProtocolVersion());
        }).onErrorMap(throwable -> new ProtocolException("Failed to initialize protocol: " + throwable.getMessage(), (Throwable)throwable));
    }

    public Mono<Void> authenticate(String methodId, AuthMethodInfo authMethodInfo) {
        if (this.authenticated) {
            log.info("Already authenticated");
            return Mono.empty();
        }
        return Mono.defer(() -> {
            AuthenticateParams params = AuthenticateParams.builder().methodId(methodId).methodInfo(authMethodInfo).build();
            return this.sendRequest(AgentMethod.AUTHENTICATE, params).flatMap(requestId -> this.receiveResponse((AgentMethod)AgentMethod.AUTHENTICATE, (String)requestId));
        }).doOnSuccess(result -> {
            String responseMethod = result.getMethodId();
            if (methodId.equals(responseMethod)) {
                this.authenticated = true;
                log.info("Authentication successful with method: {}", (Object)responseMethod);
            } else {
                log.warn("Unexpected methodId in response: {} (expected {})", (Object)responseMethod, (Object)methodId);
                this.authenticated = true;
            }
        }).then().onErrorMap(throwable -> new AuthenticationException("Authentication failed: " + throwable.getMessage(), (Throwable)throwable));
    }

    public Mono<String> createSession(String cwd, List<McpServerConfig> mcpServers) {
        return this.createSession(cwd, mcpServers, null, null, null, null);
    }

    public Mono<String> createSession(String cwd, List<McpServerConfig> mcpServers, Map<HookEventType, List<HookEventConfig>> hooks, List<CommandConfig> commands, List<CreateAgentConfig> agents, SessionSettings settings) {
        return Mono.defer(() -> {
            if (!this.initialized) {
                return Mono.error((Throwable)new ProtocolException("Protocol not initialized. Call initialize() first."));
            }
            if (!this.authenticated) {
                return Mono.error((Throwable)new ProtocolException("Not authenticated. Call authenticate() first."));
            }
            return Mono.empty();
        }).then(Mono.defer(() -> {
            SessionNewParams.SessionNewParamsBuilder paramsBuilder = SessionNewParams.builder().cwd(cwd).mcpServers(mcpServers != null ? mcpServers : new ArrayList());
            if (hooks != null) {
                paramsBuilder.hooks(hooks);
            }
            if (commands != null) {
                paramsBuilder.commands(commands);
            }
            if (agents != null) {
                paramsBuilder.agents(agents);
            }
            if (settings != null) {
                paramsBuilder.settings(settings);
            }
            SessionNewParams params = paramsBuilder.build();
            return this.sendRequest(AgentMethod.SESSION_NEW, params).flatMap(requestId -> this.receiveResponse((AgentMethod)AgentMethod.SESSION_NEW, (String)requestId));
        }).map(result -> {
            String sessionId = result.getSessionId();
            log.info("Created session: {}", (Object)sessionId);
            return sessionId;
        }).onErrorMap(throwable -> new ProtocolException("Failed to create session: " + throwable.getMessage(), (Throwable)throwable)));
    }

    public Mono<String> loadSession(String sessionId, String cwd, List<McpServerConfig> mcpServers) {
        return this.loadSession(sessionId, cwd, mcpServers, null, null, null, null);
    }

    public Mono<String> loadSession(String sessionId, String cwd, List<McpServerConfig> mcpServers, Map<HookEventType, List<HookEventConfig>> hooks, List<CommandConfig> commands, List<CreateAgentConfig> agents, Map<String, Object> settings) {
        return Mono.defer(() -> {
            if (!this.initialized) {
                return Mono.error((Throwable)new ProtocolException("Protocol not initialized. Call initialize() first."));
            }
            if (!this.authenticated) {
                return Mono.error((Throwable)new ProtocolException("Not authenticated. Call authenticate() first."));
            }
            return Mono.empty();
        }).then(Mono.defer(() -> {
            LoadSessionParams params = new LoadSessionParams();
            params.setSessionId(sessionId);
            params.setCwd(cwd);
            params.setMcpServers(mcpServers != null ? mcpServers : new ArrayList());
            if (hooks != null) {
                params.setHooks(hooks);
            }
            if (commands != null) {
                params.setCommands(commands);
            }
            if (agents != null) {
                params.setAgents(agents);
            }
            if (settings != null) {
                params.setSettings(settings);
            }
            return this.sendRequest(AgentMethod.SESSION_LOAD, params).flatMap(requestId -> this.receiveResponse((AgentMethod)AgentMethod.SESSION_LOAD, (String)requestId)).map(response -> {
                log.info("Session load response received for sessionId: {}", (Object)sessionId);
                return sessionId;
            });
        }).doOnSuccess(result -> log.info("Session loaded successfully: {}", result)).onErrorMap(throwable -> {
            String message = throwable.getMessage();
            if (message != null && message.contains("-32601")) {
                return new ProtocolException("session/load is not supported by the current iFlow version. Use session/new to create a new session instead.");
            }
            return new ProtocolException("Failed to load session: " + message, (Throwable)throwable);
        }));
    }

    public Mono<String> sendPrompt(String sessionId, List<Content> prompt) {
        return Mono.defer(() -> {
            if (!this.initialized) {
                return Mono.error((Throwable)new ProtocolException("Protocol not initialized. Call initialize() first."));
            }
            if (!this.authenticated) {
                return Mono.error((Throwable)new ProtocolException("Not authenticated. Call authenticate() first."));
            }
            return Mono.empty();
        }).then(Mono.defer(() -> {
            PromptParams params = PromptParams.builder().sessionId(sessionId).prompt(prompt).build();
            String requestId = this.nextRequestId();
            Object request = ((JsonRpcRequest.JsonRpcRequestBuilder)((JsonRpcRequest.JsonRpcRequestBuilder)((JsonRpcRequest.JsonRpcRequestBuilder)JsonRpcRequest.builder().id(requestId)).method(AgentMethod.SESSION_PROMPT.getMethodName())).params((PromptParams)params)).build();
            return this.transport.send(request).then(Mono.just((Object)requestId));
        }).doOnSuccess(requestId -> log.debug("Sent session/prompt with {} content blocks", (Object)prompt.size())).onErrorMap(throwable -> new ProtocolException("Failed to send prompt: " + throwable.getMessage(), (Throwable)throwable)));
    }

    public Mono<Void> cancelSession(String sessionId) {
        return Mono.defer(() -> {
            SessionCancelParams params = SessionCancelParams.builder().sessionId(sessionId).build();
            return this.sendRequest(AgentMethod.SESSION_CANCEL, params).then(Mono.empty());
        }).doOnSuccess(result -> log.info("Sent session/cancel request")).then().onErrorMap(throwable -> new ProtocolException("Failed to cancel session: " + throwable.getMessage(), (Throwable)throwable));
    }

    private void startHandleMessages() {
        this.transport.receive().mapNotNull(this::toJsonNode).filter(Objects::nonNull).concatMap(this::handleClientMessage).doOnNext(arg_0 -> this.messageSink.tryEmitNext(arg_0)).doOnNext(message -> log.debug("Received message: {}", message)).doOnSubscribe(subscription -> log.debug("Started message handling")).doOnComplete(() -> log.debug("Message handling completed")).doOnError(error -> log.error("Message handling error: {}", (Object)error.getMessage())).subscribeOn(Schedulers.boundedElastic()).subscribe();
    }

    public Flux<Map<String, Object>> receiveMessages() {
        return this.messageSink.asFlux();
    }

    private Flux<Map<String, Object>> handleClientMessage(JsonElement data) {
        try {
            JsonObject jsonObj = data.getAsJsonObject();
            if (jsonObj.has("method") && !jsonObj.has("result") && !jsonObj.has("error")) {
                return Flux.just(this.handleClientMethod(jsonObj));
            }
            if (jsonObj.has("id") && (jsonObj.has("result") || jsonObj.has("error"))) {
                this.handleResponse(jsonObj);
                if (jsonObj.has("result")) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("type", "response");
                    result.put("id", jsonObj.get("id").getAsString());
                    result.put("result", this.gson.fromJson(jsonObj.get("result"), Object.class));
                    return Flux.just(result);
                }
                if (jsonObj.has("error")) {
                    log.error("Error response: {}", (Object)jsonObj.get("error"));
                    HashMap<String, String> errorResult = new HashMap<String, String>();
                    JsonObject error = jsonObj.get("error").getAsJsonObject();
                    errorResult.put("type", "error");
                    errorResult.put("code", error.get("code").getAsString());
                    errorResult.put("message", error.get("message").getAsString());
                    errorResult.put("data", this.gson.toJson(error.get("data")));
                    return Flux.just(errorResult);
                }
            }
            return Flux.empty();
        }
        catch (Exception e) {
            log.error("Error processing message ", (Throwable)e);
            HashMap<String, Object> errorResult = new HashMap<String, Object>();
            errorResult.put("type", "error");
            errorResult.put("error", "Failed to process message: " + e.getMessage());
            return Flux.just(errorResult);
        }
    }

    private Map<String, Object> handleClientMethod(JsonObject data) {
        String methodName = data.get("method").getAsString();
        JsonElement params = data.get("params");
        Object requestId = data.has("id") ? this.gson.fromJson(data.get("id"), Object.class) : null;
        try {
            switch (methodName) {
                case "session/update": {
                    return this.handleSessionUpdate(params);
                }
                case "session/request_permission": {
                    return this.handlePermissionRequest(params, requestId);
                }
                case "fs/read_text_file": {
                    return this.handleFileRead(params, requestId);
                }
                case "fs/write_text_file": {
                    return this.handleFileWrite(params, requestId);
                }
            }
            log.warn("Unknown method: {}", (Object)methodName);
            if (requestId != null) {
                this.sendError(requestId, -32601, "Method not found");
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("type", "unknown");
            result.put("method", methodName);
            result.put("params", params);
            return result;
        }
        catch (Exception e) {
            log.error("Error handling client method {}: {}", (Object)methodName, (Object)e.getMessage());
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("type", "error");
            result.put("method", methodName);
            result.put("error", e.getMessage());
            return result;
        }
    }

    private JsonElement toJsonNode(String message) {
        if (message.startsWith("//")) {
            log.info("Control message: {}", (Object)message);
            return null;
        }
        try {
            return (JsonElement)this.gson.fromJson(message, JsonElement.class);
        }
        catch (Exception e) {
            log.info("Failed to parse message: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> handleSessionUpdate(JsonElement params) {
        JsonObject paramsObj = params.getAsJsonObject();
        JsonObject update = paramsObj.get("update").getAsJsonObject();
        String updateType = update.get("sessionUpdate").getAsString();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", "session_update");
        result.put("sessionId", paramsObj.get("sessionId").getAsString());
        result.put("update_type", updateType);
        result.put("update", this.gson.fromJson((JsonElement)update, Object.class));
        if (update.has("agentId")) {
            result.put("agentId", update.get("agentId").getAsString());
        }
        return result;
    }

    private Map<String, Object> handlePermissionRequest(JsonElement params, Object requestId) {
        PermissionRequestParams permissionParams = (PermissionRequestParams)this.gson.fromJson(params, PermissionRequestParams.class);
        if (this.permissionCallback != null) {
            this.permissionCallback.apply(permissionParams).doOnNext(result -> {
                if (requestId != null) {
                    this.sendResponse(requestId, result);
                }
            }).doOnError(error -> {
                log.error("Error in permission callback ", error);
                if (requestId != null) {
                    this.sendResponse(requestId, PermissionRequestResult.builder().outcome(PermissionRequestResult.Outcome.of("cancelled", null)));
                }
            }).doFinally(signalType -> log.debug("Permission callback finished")).subscribeOn(Schedulers.boundedElastic()).subscribe();
        } else if (requestId != null) {
            log.error("No permission callback configured");
            this.sendResponse(requestId, PermissionRequestResult.builder().outcome(PermissionRequestResult.Outcome.of("cancelled", null)));
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("type", "permission_request");
        result2.put("params", permissionParams);
        return result2;
    }

    private Map<String, Object> handleFileRead(JsonElement params, Object requestId) {
        FileReadParams fileReadParams = (FileReadParams)this.gson.fromJson(params, FileReadParams.class);
        log.info("fs/read_text_file request for: {}", (Object)fileReadParams.getPath());
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.fileReadCallback != null) {
            this.fileReadCallback.apply(fileReadParams).doOnNext(response -> {
                if (requestId != null) {
                    this.sendResponse(requestId, response);
                }
                result.put("type", "file_read");
                result.put("path", fileReadParams.getPath());
                result.put("response", response);
            }).doOnError(error -> {
                log.error("Error reading file {}: {}", (Object)fileReadParams.getPath(), (Object)error.getMessage());
                if (requestId != null) {
                    this.sendError(requestId, -32603, error.getMessage());
                }
                result.put("type", "error");
                result.put("method", "fs/read_text_file");
                result.put("error", error.getMessage());
            }).subscribe();
        } else {
            String errorMsg = "File read callback not configured";
            if (requestId != null) {
                this.sendError(requestId, -32603, errorMsg);
            }
            result.put("type", "error");
            result.put("method", "fs/read_text_file");
            result.put("error", errorMsg);
        }
        return result;
    }

    private Map<String, Object> handleFileWrite(JsonElement params, Object requestId) {
        FileWriteParams fileWriteParams = (FileWriteParams)this.gson.fromJson(params, FileWriteParams.class);
        log.info("fs/write_text_file request for: {}", (Object)fileWriteParams.getPath());
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.FileWriteCallback != null) {
            this.FileWriteCallback.apply(fileWriteParams).doOnNext(response -> {
                if (requestId != null) {
                    this.sendResponse(requestId, response);
                }
                result.put("type", "file_write");
                result.put("path", fileWriteParams.getPath());
                result.put("response", response);
            }).doOnError(error -> {
                log.error("Error writing file {}: {}", (Object)fileWriteParams.getPath(), (Object)error.getMessage());
                if (requestId != null) {
                    this.sendError(requestId, -32603, error.getMessage());
                }
                result.put("type", "error");
                result.put("method", "fs/write_text_file");
                result.put("error", error.getMessage());
            }).subscribe();
        } else {
            String errorMsg = "File write callback not configured";
            if (requestId != null) {
                this.sendError(requestId, -32603, errorMsg);
            }
            result.put("type", "error");
            result.put("method", "fs/write_text_file");
            result.put("error", errorMsg);
        }
        return result;
    }

    private void sendResponse(Object requestId, Object result) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("jsonrpc", "2.0");
        response.put("id", requestId);
        response.put("result", result);
        try {
            this.transport.send(response).block();
        }
        catch (Exception e) {
            log.error("Failed to send response: {}", (Object)e.getMessage());
        }
    }

    private void sendError(Object requestId, int code, String message) {
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("code", code);
        error.put("message", message);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("jsonrpc", "2.0");
        response.put("id", requestId);
        response.put("error", error);
        try {
            this.transport.send(response).block();
        }
        catch (Exception e) {
            log.error("Failed to send error response: {}", (Object)e.getMessage());
        }
    }

    private void handleResponse(JsonObject data) {
        String requestId = data.get("id").getAsString();
        MonoSink<JsonElement> jsonElementMonoSink = this.pendingResponseSinks.get(requestId);
        log.debug("Received response for request ID: {}", (Object)requestId);
        if (jsonElementMonoSink == null) {
            return;
        }
        this.pendingResponseSinks.get(requestId).success((Object)data);
    }

    public <Param, Result> Mono<String> sendRequest(AgentMethod<Param, Result> method, Param params) {
        if (method == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Method cannot be null"));
        }
        String requestId = this.nextRequestId();
        Object request = ((JsonRpcRequest.JsonRpcRequestBuilder)((JsonRpcRequest.JsonRpcRequestBuilder)((JsonRpcRequest.JsonRpcRequestBuilder)JsonRpcRequest.builder().id(requestId)).method(method.getMethodName())).params(params)).build();
        if (method.isNotification()) {
            return this.transport.send(request).then(Mono.just((Object)requestId));
        }
        Mono pendingResponseMono = Mono.create(sink -> this.pendingResponseSinks.put(requestId, (MonoSink<JsonElement>)sink));
        this.pendingResponses.put(requestId, (Mono<JsonElement>)pendingResponseMono);
        return this.transport.send(request).then(Mono.just((Object)requestId)).doOnError(e -> {
            this.pendingResponseSinks.remove(requestId);
            this.pendingResponses.remove(requestId);
        }).onErrorResume(e -> Mono.error((Throwable)new IFlowException("Failed to send request", (Throwable)e)));
    }

    public <Param, Result> Mono<Result> receiveResponse(AgentMethod<Param, Result> method, String requestId) {
        if (method == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Method cannot be null"));
        }
        Mono<JsonElement> stringMono = this.pendingResponses.get(requestId);
        return stringMono.handle((jsonElement, sink) -> {
            JsonObject jsonObj = jsonElement.getAsJsonObject();
            if (jsonObj.has("error")) {
                sink.error((Throwable)new ProtocolException("Request failed: " + this.gson.toJson(jsonObj.get("error"))));
            } else {
                Object result = this.gson.fromJson(jsonObj.get("result"), method.getResultClass());
                sink.next(result);
            }
        }).doFinally(signalType -> {
            this.pendingResponses.remove(requestId);
            this.pendingResponseSinks.remove(requestId);
        });
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public boolean isAuthenticated() {
        return this.authenticated;
    }
}

