/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.file;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSystemHandler.class);
    private final boolean readOnly;
    private final long maxFileSize;
    private final Set<Path> allowedDirs;

    public FileSystemHandler() {
        this(null, false, 0xA00000L);
    }

    public FileSystemHandler(List<String> allowedDirs, boolean readOnly, long maxFileSize) {
        this.readOnly = readOnly;
        this.maxFileSize = maxFileSize;
        this.allowedDirs = new HashSet<Path>();
        if (allowedDirs == null || allowedDirs.isEmpty()) {
            this.allowedDirs.add(Paths.get("", new String[0]).toAbsolutePath().normalize());
        } else {
            for (String string : allowedDirs) {
                Path resolvedPath = Paths.get(string, new String[0]).toAbsolutePath().normalize();
                this.allowedDirs.add(resolvedPath);
            }
        }
        log.info("FileSystemHandler initialized with " + this.allowedDirs.size() + " allowed directories");
        for (Path path : this.allowedDirs) {
            log.debug("  Allowed: " + path);
        }
    }

    private boolean isPathAllowed(String filePath) {
        try {
            Path absPath = Paths.get(filePath, new String[0]).toAbsolutePath().normalize();
            for (Path allowedDir : this.allowedDirs) {
                if (!absPath.startsWith(allowedDir)) continue;
                return true;
            }
            log.warn("Path not in allowed directories: " + absPath);
            return false;
        }
        catch (Exception e) {
            log.error("Error checking path: " + e.getMessage());
            return false;
        }
    }

    public String readFile(String filePath, Integer line, Integer limit) throws IOException {
        if (!this.isPathAllowed(filePath)) {
            throw new SecurityException("Access denied: " + filePath);
        }
        Path absPath = Paths.get(filePath, new String[0]).toAbsolutePath().normalize();
        if (!Files.exists(absPath, new LinkOption[0])) {
            throw new IOException("File not found: " + filePath);
        }
        if (!Files.isRegularFile(absPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Not a file: " + filePath);
        }
        long fileSize = Files.size(absPath);
        if (fileSize > this.maxFileSize) {
            throw new IllegalArgumentException("File too large: " + fileSize + " bytes (max: " + this.maxFileSize + ")");
        }
        try {
            if (line != null || limit != null) {
                List<String> lines = Files.readAllLines(absPath, StandardCharsets.UTF_8);
                int startLine = line != null ? line - 1 : 0;
                int endLine = startLine + (limit != null ? limit.intValue() : lines.size());
                startLine = Math.max(0, startLine);
                endLine = Math.min(lines.size(), endLine);
                StringBuilder result = new StringBuilder();
                for (int i = startLine; i < endLine; ++i) {
                    if (i > startLine) {
                        result.append("\n");
                    }
                    result.append(lines.get(i));
                }
                if (endLine > startLine && endLine < lines.size()) {
                    result.append("\n");
                }
                return result.toString();
            }
            return Files.readString(absPath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            try {
                return Files.readString(absPath, StandardCharsets.ISO_8859_1);
            }
            catch (IOException fallbackException) {
                throw new IOException("Failed to read file: " + e.getMessage(), e);
            }
        }
    }

    public void writeFile(String filePath, String content) throws IOException {
        if (this.readOnly) {
            throw new SecurityException("File system is in read-only mode");
        }
        if (!this.isPathAllowed(filePath)) {
            throw new SecurityException("Access denied: " + filePath);
        }
        Path absPath = Paths.get(filePath, new String[0]).toAbsolutePath().normalize();
        Path parentDir = absPath.getParent();
        if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        try {
            Files.writeString(absPath, (CharSequence)content, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            log.info("Wrote " + content.length() + " characters to " + filePath);
        }
        catch (IOException e) {
            throw new IOException("Failed to write file: " + e.getMessage(), e);
        }
    }

    public void addAllowedDirectory(String directory) {
        Path absDir = Paths.get(directory, new String[0]).toAbsolutePath().normalize();
        if (!Files.exists(absDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Directory does not exist: " + directory);
        }
        if (!Files.isDirectory(absDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Not a directory: " + directory);
        }
        this.allowedDirs.add(absDir);
        log.info("Added allowed directory: " + absDir);
    }

    public void removeAllowedDirectory(String directory) {
        Path absDir = Paths.get(directory, new String[0]).toAbsolutePath().normalize();
        this.allowedDirs.remove(absDir);
        log.info("Removed allowed directory: " + absDir);
    }

    public Set<Path> getAllowedDirectories() {
        return new HashSet<Path>(this.allowedDirs);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }
}

