/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.examples;

import cn.iflow.sdk.query.IFlowQuery;
import cn.iflow.sdk.types.config.IFlowOptions;
import cn.iflow.sdk.types.messages.AssistantMessage;
import cn.iflow.sdk.types.messages.ErrorMessage;
import cn.iflow.sdk.types.messages.Message;
import cn.iflow.sdk.types.messages.PlanMessage;
import cn.iflow.sdk.types.messages.ToolCallMessage;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class QuickStartExample {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuickStartExample.class);

    public static void main(String[] args) {
        log.info("Starting Quick Start Examples");
        try {
            QuickStartExample.simpleAsyncQuery();
            QuickStartExample.queryWithFiles();
            QuickStartExample.streamingQuery();
            QuickStartExample.sandboxQuery();
            QuickStartExample.synchronousQuery();
            System.out.println("\u2705 Quick start examples completed!");
        }
        catch (Exception e) {
            log.error("Example failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void simpleAsyncQuery() {
        System.out.println("\nExample 1: Simple async query");
        System.out.println("-".repeat(40));
        try {
            Mono<List<Message>> query = IFlowQuery.query("What is 2 + 2?");
            AssistantMessage message = (AssistantMessage)((List)query.block()).get(0);
            System.out.println("Response: " + message.getChunk().getText());
            System.out.println();
        }
        catch (Exception e) {
            System.err.println("Query failed: " + e.getMessage());
            System.out.println("Note: Requires running iFlow instance");
            System.out.println();
        }
    }

    private static void queryWithFiles() {
        System.out.println("Example 2: Query with files");
        System.out.println("-".repeat(40));
        try {
            List<Path> files = List.of(Paths.get("README.md", new String[0]), Paths.get("pom.xml", new String[0]));
            System.out.println("(Skipped - add actual file paths to test)");
            System.out.println("Files would be: " + files);
            System.out.println();
        }
        catch (Exception e) {
            System.err.println("File query failed: " + e.getMessage());
            System.out.println();
        }
    }

    private static void streamingQuery() {
        System.out.println("Example 3: Streaming response");
        System.out.println("-".repeat(40));
        try {
            System.out.print("Assistant: ");
            Flux<Message> messageFlux = IFlowQuery.queryStream("Tell me a short joke");
            AtomicBoolean completed = new AtomicBoolean(false);
            messageFlux.takeUntil(message -> completed.get()).doOnNext(message -> {
                switch (message.getType()) {
                    case ASSISTANT_MESSAGE: {
                        AssistantMessage assistantMsg = (AssistantMessage)message;
                        if (assistantMsg.getChunk().getText() == null) break;
                        String text = assistantMsg.getChunk().getText();
                        System.out.print(text);
                        break;
                    }
                    case PLAN: {
                        PlanMessage plan = (PlanMessage)message;
                        System.out.println("\n   \ud83d\udcdd [\u8ba1\u5212: " + plan + "]");
                        break;
                    }
                    case TOOL_CALL: {
                        ToolCallMessage toolCall = (ToolCallMessage)message;
                        System.out.println("\n   \ud83e\udd16 [\u5de5\u5177\u8c03\u7528: " + toolCall.getContent().toString() + "]");
                        break;
                    }
                    case ERROR: {
                        ErrorMessage error = (ErrorMessage)message;
                        System.out.println("\n   \u274c [\u9519\u8bef: " + error.getErrorMessage() + "]");
                        break;
                    }
                    case TASK_FINISH: {
                        completed.set(true);
                    }
                }
            }).blockLast();
        }
        catch (Exception e) {
            System.err.println("Streaming failed: " + e.getMessage());
            System.out.println();
        }
    }

    private static void sandboxQuery() {
        System.out.println("Example 4: Sandbox query");
        System.out.println("-".repeat(40));
        try {
            IFlowOptions sandboxOptions = IFlowOptions.getDefault().forSandbox();
            System.out.println("(Skipped - requires sandbox access)");
            System.out.println("Sandbox URL: wss://sandbox.iflow.ai/acp");
            System.out.println();
            Mono<List<Message>> query = IFlowQuery.query("Hello from sandbox!", sandboxOptions);
            AssistantMessage message = (AssistantMessage)((List)query.block()).get(0);
            System.out.println("Response: " + message.getChunk().getText());
        }
        catch (Exception e) {
            System.err.println("Sandbox failed: " + e.getMessage());
            System.out.println("Make sure you have sandbox access configured");
            System.out.println();
        }
    }

    private static void synchronousQuery() {
        System.out.println("Example 5: Synchronous query");
        System.out.println("-".repeat(40));
        try {
            List<Message> messages = IFlowQuery.querySync("What is the capital of France?", Duration.ofSeconds(30L));
            AssistantMessage message = (AssistantMessage)messages.get(0);
            System.out.println("Response: " + message.getChunk().getText());
            System.out.println();
        }
        catch (Exception e) {
            System.err.println("Sync query failed: " + e.getMessage());
            System.out.println("Note: Requires running iFlow instance");
            System.out.println("In a real deployment, this would return the answer immediately.");
            System.out.println();
        }
    }
}

