/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.examples;

import cn.iflow.sdk.core.IFlowClient;
import cn.iflow.sdk.types.config.IFlowOptions;
import cn.iflow.sdk.types.enums.PermissionMode;
import cn.iflow.sdk.types.messages.AssistantMessage;
import cn.iflow.sdk.types.messages.ErrorMessage;
import cn.iflow.sdk.types.messages.ToolCallMessage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoAdvanced {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DemoAdvanced.class);
    private IFlowClient client;
    private final List<String> conversationHistory = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.println("\n\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557\n\u2551       iFlow SDK \u9ad8\u7ea7\u529f\u80fd\u6f14\u793a - \u590d\u6742\u573a\u666f               \u2551\n\u2551                                                        \u2551\n\u2551  \u5c55\u793a\uff1a\u591a\u8f6e\u5bf9\u8bdd\u3001Agent \u4f7f\u7528\u3001\u5de5\u5177\u8c03\u7528                 \u2551\n\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        DemoAdvanced demo = new DemoAdvanced();
        Scanner scanner = new Scanner(System.in);
        try {
            demo.setup();
            LinkedHashMap<String, Runnable> demos = new LinkedHashMap<String, Runnable>();
            demos.put("\u4ee3\u7801\u751f\u6210", demo::demoCodeGeneration);
            demos.put("\u4ee3\u7801\u5206\u6790", demo::demoAnalysisTask);
            demos.put("\u9879\u76ee\u63a2\u7d22", demo::demoProjectExploration);
            demos.put("\u8c03\u8bd5\u573a\u666f", demo::demoDebuggingScenario);
            demos.put("\u7cfb\u7edf\u8bbe\u8ba1", demo::demoSystemDesign);
            demos.put("\u4ee3\u7801\u91cd\u6784", demo::demoRefactoring);
            System.out.println("\u8bf7\u9009\u62e9\u6f14\u793a\u573a\u666f\uff1a");
            int i = 1;
            for (Object name : demos.keySet()) {
                System.out.println("  " + i + ". " + (String)name);
                ++i;
            }
            System.out.println("  7. \u8fd0\u884c\u6240\u6709\u6f14\u793a");
            System.out.println("  0. \u9000\u51fa");
            System.out.print("\n\u8bf7\u8f93\u5165\u9009\u62e9 (0-7): ");
            String choice = scanner.nextLine().strip();
            if ("0".equals(choice)) {
                System.out.println("\u9000\u51fa\u6f14\u793a");
            } else if ("7".equals(choice)) {
                for (Map.Entry entry : demos.entrySet()) {
                    System.out.println("\n" + "=".repeat(80));
                    System.out.println("\u5f00\u59cb: " + (String)entry.getKey());
                    System.out.println("=".repeat(80));
                    ((Runnable)entry.getValue()).run();
                    Thread.sleep(3000L);
                }
            } else if (choice.matches("[1-6]")) {
                int idx = Integer.parseInt(choice) - 1;
                String[] stringArray = demos.keySet().toArray(new String[0]);
                String selectedName = stringArray[idx];
                Runnable selectedDemo = (Runnable)demos.get(selectedName);
                selectedDemo.run();
            } else {
                System.out.println("\u65e0\u6548\u7684\u9009\u62e9");
            }
        }
        catch (Exception e) {
            System.err.println("\n\u274c \u53d1\u751f\u9519\u8bef: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            demo.cleanup();
            scanner.close();
            System.out.println("\n" + "=".repeat(80));
            System.out.println("\ud83d\udcca \u6f14\u793a\u7edf\u8ba1");
            System.out.println("-".repeat(80));
            System.out.println("\u2705 \u5bf9\u8bdd\u8f6e\u6570: " + demo.conversationHistory.size());
            System.out.println("\u2705 \u5c55\u793a\u529f\u80fd:");
            System.out.println("   \u2022 \u591a\u8f6e\u5bf9\u8bdd\u4e0a\u4e0b\u6587\u4fdd\u6301");
            System.out.println("   \u2022 \u590d\u6742\u4efb\u52a1\u5206\u89e3");
            System.out.println("   \u2022 \u5de5\u5177\u8c03\u7528\uff08\u6587\u4ef6\u64cd\u4f5c\u3001\u4ee3\u7801\u5206\u6790\u7b49\uff09");
            System.out.println("   \u2022 Agent \u534f\u4f5c");
            System.out.println("   \u2022 \u81ea\u52a8\u8fdb\u7a0b\u7ba1\u7406");
            System.out.println("\n\u2728 \u6f14\u793a\u5b8c\u6210\uff01");
        }
    }

    private void setup() throws Exception {
        System.out.println("\ud83d\ude80 \u521d\u59cb\u5316 iFlow \u5ba2\u6237\u7aef...");
        IFlowOptions options = IFlowOptions.builder().autoStartProcess(true).processStartPort(11000).permissionMode(PermissionMode.AUTO).cwd(System.getProperty("user.dir")).build();
        this.client = IFlowClient.create(options);
        this.client.connect().block();
        System.out.println("\u2705 \u5df2\u8fde\u63a5: ws://localhost:8090/acp\n");
    }

    private void cleanup() {
        if (this.client != null) {
            try {
                this.client.disconnect().block();
                System.out.println("\n\ud83d\udd04 \u5ba2\u6237\u7aef\u5df2\u65ad\u5f00\uff0c\u8fdb\u7a0b\u5df2\u6e05\u7406");
            }
            catch (Exception e) {
                log.warn("Cleanup failed: " + e.getMessage());
            }
        }
    }

    private String sendAndReceive(String prompt, boolean showTools) {
        System.out.println("\ud83d\udc64 \u7528\u6237: " + prompt);
        System.out.println("-".repeat(60));
        try {
            this.client.sendMessage(prompt).block();
            StringBuilder responseBuilder = new StringBuilder();
            ArrayList toolCalls = new ArrayList();
            AtomicBoolean finished = new AtomicBoolean(false);
            System.out.print("\ud83e\udd16 Assistant: ");
            this.client.receiveMessages().takeUntil(msg -> finished.get()).doOnNext(message -> {
                switch (message.getType()) {
                    case ASSISTANT_MESSAGE: {
                        AssistantMessage assistantMsg = (AssistantMessage)message;
                        if (assistantMsg.getChunk().getText() == null) break;
                        String text = assistantMsg.getChunk().getText();
                        System.out.print(text);
                        responseBuilder.append(text);
                        break;
                    }
                    case TOOL_CALL: {
                        ToolCallMessage toolCall = (ToolCallMessage)message;
                        if (!showTools) break;
                        if (toolCalls.isEmpty()) {
                            System.out.println();
                        }
                        System.out.println("   \ud83d\udd27 [\u5de5\u5177\u8c03\u7528: " + toolCall.getLabel() + "]");
                        toolCalls.add(toolCall.getLabel());
                        break;
                    }
                    case TASK_FINISH: {
                        System.out.println("\n");
                        finished.set(true);
                        break;
                    }
                    case ERROR: {
                        ErrorMessage error = (ErrorMessage)message;
                        System.out.println("\n\u274c \u9519\u8bef: " + error.getErrorMessage());
                        finished.set(true);
                    }
                }
            }).doOnComplete(() -> finished.set(true)).blockLast(Duration.ofSeconds(300L));
            String fullResponse = responseBuilder.toString();
            this.conversationHistory.add("Q: " + prompt + "\nA: " + fullResponse);
            return fullResponse;
        }
        catch (Exception e) {
            System.err.println("\u53d1\u9001\u6d88\u606f\u5931\u8d25: " + e.getMessage());
            return "";
        }
    }

    private void demoCodeGeneration() {
        System.out.println("\n" + "=".repeat(80));
        System.out.println("\ud83d\udcdd \u6f14\u793a 1: \u590d\u6742\u4ee3\u7801\u751f\u6210 - \u521b\u5efa\u4e00\u4e2a\u5b8c\u6574\u7684\u5e94\u7528");
        System.out.println("=".repeat(80) + "\n");
        this.sendAndReceive("\u6211\u60f3\u521b\u5efa\u4e00\u4e2a Java \u7684\u4efb\u52a1\u7ba1\u7406\u7cfb\u7edf\uff0c\u9700\u8981\u6709\u4ee5\u4e0b\u529f\u80fd\uff1a\n1. \u6dfb\u52a0\u4efb\u52a1\uff08\u6807\u9898\u3001\u63cf\u8ff0\u3001\u4f18\u5148\u7ea7\u3001\u622a\u6b62\u65e5\u671f\uff09\n2. \u5217\u51fa\u6240\u6709\u4efb\u52a1\n3. \u6807\u8bb0\u4efb\u52a1\u5b8c\u6210\n4. \u5220\u9664\u4efb\u52a1\n5. \u6309\u4f18\u5148\u7ea7\u6216\u622a\u6b62\u65e5\u671f\u6392\u5e8f\n6. \u6570\u636e\u6301\u4e45\u5316\u5230 JSON \u6587\u4ef6\n\u8bf7\u5148\u5e2e\u6211\u8bbe\u8ba1\u7cfb\u7edf\u67b6\u6784\uff0c\u7136\u540e\u5b9e\u73b0\u4ee3\u7801\u3002", true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.sendAndReceive("\u5f88\u597d\uff01\u73b0\u5728\u8bf7\u5b9e\u73b0\u4e3b\u8981\u7684 Task \u7c7b\u548c TaskManager \u7c7b\uff0c\u8981\u5305\u542b\u5b8c\u6574\u7684\u9519\u8bef\u5904\u7406\u548c\u7c7b\u578b\u6ce8\u89e3\u3002", true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.sendAndReceive("\u73b0\u5728\u6dfb\u52a0\u4e00\u4e2a\u547d\u4ee4\u884c\u754c\u9762\uff08CLI\uff09\uff0c\u8ba9\u7528\u6237\u53ef\u4ee5\u4ea4\u4e92\u5f0f\u5730\u4f7f\u7528\u8fd9\u4e2a\u7cfb\u7edf\u3002\u4f7f\u7528 Scanner \u6216\u8005\u7b80\u5355\u7684\u83dc\u5355\u7cfb\u7edf\u90fd\u53ef\u4ee5\u3002", true);
    }

    private void demoAnalysisTask() {
        System.out.println("\n" + "=".repeat(80));
        System.out.println("\ud83d\udd0d \u6f14\u793a 2: \u4ee3\u7801\u5206\u6790\u4e0e\u4f18\u5316");
        System.out.println("=".repeat(80) + "\n");
        String code = "import java.util.*;\n\npublic class DataProcessor {\n    public List<Integer> findDuplicates(List<Integer> list) {\n        List<Integer> duplicates = new ArrayList<>();\n        for (int i = 0; i < list.size(); i++) {\n            for (int j = i + 1; j < list.size(); j++) {\n                if (list.get(i).equals(list.get(j)) && !duplicates.contains(list.get(i))) {\n                    duplicates.add(list.get(i));\n                }\n            }\n        }\n        return duplicates;\n    }\n    \n    public List<Integer> processData(List<Integer> data) {\n        List<Integer> result = new ArrayList<>();\n        for (Integer item : data) {\n            if (item > 0) {\n                result.add(item * 2);\n            }\n        }\n        return result;\n    }\n}";
        this.sendAndReceive("\u8bf7\u5206\u6790\u4ee5\u4e0b Java \u4ee3\u7801\u7684\u6027\u80fd\u95ee\u9898\uff0c\u5e76\u63d0\u4f9b\u4f18\u5316\u7248\u672c\uff1a\n```java\n" + code + "\n```\n\u8981\u6c42\uff1a\n1. \u6307\u51fa\u6027\u80fd\u74f6\u9888\n2. \u63d0\u4f9b\u65f6\u95f4\u590d\u6742\u5ea6\u5206\u6790\n3. \u7ed9\u51fa\u4f18\u5316\u540e\u7684\u4ee3\u7801\n4. \u6dfb\u52a0\u9002\u5f53\u7684\u6cdb\u578b\u548c\u6ce8\u89e3", true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.sendAndReceive("\u80fd\u5426\u4e3a\u4f18\u5316\u540e\u7684\u4ee3\u7801\u7f16\u5199\u5355\u5143\u6d4b\u8bd5\uff1f\u4f7f\u7528 JUnit 5 \u6846\u67b6\u3002", true);
    }

    private void demoProjectExploration() {
        System.out.println("\n" + "=".repeat(80));
        System.out.println("\ud83d\udd0e \u6f14\u793a 3: \u9879\u76ee\u4ee3\u7801\u63a2\u7d22");
        System.out.println("=".repeat(80) + "\n");
        this.sendAndReceive("\u8bf7\u5206\u6790\u5f53\u524d\u9879\u76ee\uff08iflow-cli-sdk-java\uff09\u7684\u7ed3\u6784\uff0c\u544a\u8bc9\u6211\uff1a\n1. \u9879\u76ee\u7684\u4e3b\u8981\u6a21\u5757\u6709\u54ea\u4e9b\uff1f\n2. \u6838\u5fc3\u529f\u80fd\u662f\u4ec0\u4e48\uff1f\n3. \u6709\u54ea\u4e9b\u4e3b\u8981\u7684\u7c7b\u548c\u5b83\u4eec\u7684\u804c\u8d23\uff1f", true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.sendAndReceive("\u8be6\u7ec6\u89e3\u91ca\u4e00\u4e0b ACPProtocol \u7c7b\u7684\u5de5\u4f5c\u539f\u7406\uff0c\u7279\u522b\u662f\u5b83\u5982\u4f55\u5904\u7406\u6d88\u606f\u7684\u53d1\u9001\u548c\u63a5\u6536\u3002", true);
    }

    private void demoDebuggingScenario() {
        System.out.println("\n" + "=".repeat(80));
        System.out.println("\ud83d\udc1b \u6f14\u793a 4: \u8c03\u8bd5\u548c\u95ee\u9898\u89e3\u51b3");
        System.out.println("=".repeat(80) + "\n");
        String buggyCode = "import java.util.*;\n\npublic class DataProcessor {\n    private List<Integer> data = new ArrayList<>();\n    \n    public void addItem(int item) {\n        data.add(item);\n    }\n    \n    public List<Integer> processBatch(List<Integer> items) {\n        for (Integer item : items) {\n            addItem(item);\n            if (item > 100) {\n                items.remove(item);  // \u95ee\u9898\u5728\u8fd9\u91cc\n            }\n        }\n        return data;\n    }\n    \n    public double calculateAverage() {\n        return data.stream().mapToInt(Integer::intValue).sum() / data.size();\n    }\n}";
        this.sendAndReceive("\u8fd9\u6bb5\u4ee3\u7801\u6709\u4e00\u4e2a\u9690\u85cf\u7684 bug\uff0c\u8bf7\u5e2e\u6211\u627e\u51fa\u5e76\u4fee\u590d\uff1a\n```java\n" + buggyCode + "\n```\n\u7528\u6237\u62a5\u544a\u8bf4\u5904\u7406\u67d0\u4e9b\u6570\u636e\u65f6\u7ed3\u679c\u4e0d\u6b63\u786e\u3002\u8bf7\uff1a\n1. \u627e\u51fa bug\n2. \u89e3\u91ca\u4e3a\u4ec0\u4e48\u4f1a\u51fa\u73b0\u8fd9\u4e2a\u95ee\u9898\n3. \u63d0\u4f9b\u4fee\u590d\u65b9\u6848\n4. \u7f16\u5199\u6d4b\u8bd5\u7528\u4f8b\u6765\u9a8c\u8bc1\u4fee\u590d", true);
    }

    private void demoSystemDesign() {
        System.out.println("\n" + "=".repeat(80));
        System.out.println("\ud83c\udfd7\ufe0f \u6f14\u793a 5: \u7cfb\u7edf\u67b6\u6784\u8bbe\u8ba1");
        System.out.println("=".repeat(80) + "\n");
        this.sendAndReceive("\u8bbe\u8ba1\u4e00\u4e2a\u5206\u5e03\u5f0f\u65e5\u5fd7\u6536\u96c6\u7cfb\u7edf\uff0c\u8981\u6c42\uff1a\n1. \u652f\u6301\u591a\u4e2a\u5e94\u7528\u540c\u65f6\u5199\u5165\u65e5\u5fd7\n2. \u65e5\u5fd7\u8981\u6309\u65f6\u95f4\u548c\u7ea7\u522b\u5206\u7c7b\u5b58\u50a8\n3. \u63d0\u4f9b\u5b9e\u65f6\u67e5\u8be2\u548c\u5386\u53f2\u67e5\u8be2\u529f\u80fd\n4. \u8981\u6709\u5bb9\u9519\u673a\u5236\n5. \u8003\u8651\u6027\u80fd\u548c\u6269\u5c55\u6027\n\n\u8bf7\u63d0\u4f9b\uff1a\n- \u7cfb\u7edf\u67b6\u6784\u56fe\uff08\u7528\u6587\u5b57\u63cf\u8ff0\uff09\n- \u4e3b\u8981\u7ec4\u4ef6\u8bf4\u660e\n- \u6570\u636e\u6d41\u7a0b\n- \u6280\u672f\u9009\u578b\u5efa\u8bae\n- Java \u5b9e\u73b0\u7684\u6838\u5fc3\u4ee3\u7801\u6846\u67b6", true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.sendAndReceive("\u8bf7\u8be6\u7ec6\u5b9e\u73b0\u65e5\u5fd7\u6536\u96c6\u5668\uff08Log Collector\uff09\u7ec4\u4ef6\uff0c\u5305\u62ec\uff1a\n1. \u5f02\u6b65\u6536\u96c6\u673a\u5236\n2. \u6279\u91cf\u53d1\u9001\u4f18\u5316\n3. \u5931\u8d25\u91cd\u8bd5\u903b\u8f91\n4. \u80cc\u538b\u5904\u7406", true);
    }

    private void demoRefactoring() {
        System.out.println("\n" + "=".repeat(80));
        System.out.println("\u267b\ufe0f \u6f14\u793a 6: \u4ee3\u7801\u91cd\u6784");
        System.out.println("=".repeat(80) + "\n");
        String legacyCode = "import java.util.*;\n\npublic class UserProcessor {\n    public Map<String, Object> processUserData(List<Map<String, Object>> users) {\n        Map<String, Object> result = new HashMap<>();\n        for (Map<String, Object> user : users) {\n            if ((Integer) user.get(\"age\") >= 18) {\n                if (\"US\".equals(user.get(\"country\"))) {\n                    if (\"premium\".equals(user.get(\"subscription\"))) {\n                        Map<String, Object> userData = new HashMap<>();\n                        userData.put(\"name\", user.get(\"name\"));\n                        userData.put(\"email\", user.get(\"email\"));\n                        userData.put(\"discount\", 0.2);\n                        result.put((String) user.get(\"id\"), userData);\n                    } else {\n                        Map<String, Object> userData = new HashMap<>();\n                        userData.put(\"name\", user.get(\"name\"));\n                        userData.put(\"email\", user.get(\"email\"));\n                        userData.put(\"discount\", 0.1);\n                        result.put((String) user.get(\"id\"), userData);\n                    }\n                } else {\n                    if (\"premium\".equals(user.get(\"subscription\"))) {\n                        Map<String, Object> userData = new HashMap<>();\n                        userData.put(\"name\", user.get(\"name\"));\n                        userData.put(\"email\", user.get(\"email\"));\n                        userData.put(\"discount\", 0.15);\n                        result.put((String) user.get(\"id\"), userData);\n                    } else {\n                        Map<String, Object> userData = new HashMap<>();\n                        userData.put(\"name\", user.get(\"name\"));\n                        userData.put(\"email\", user.get(\"email\"));\n                        userData.put(\"discount\", 0.05);\n                        result.put((String) user.get(\"id\"), userData);\n                    }\n                }\n            }\n        }\n        return result;\n    }\n}";
        this.sendAndReceive("\u8bf7\u91cd\u6784\u8fd9\u6bb5\u4ee3\u7801\uff0c\u4f7f\u5176\u66f4\u52a0\u6e05\u6670\u548c\u53ef\u7ef4\u62a4\uff1a\n```java\n" + legacyCode + "\n```\n\u8981\u6c42\uff1a\n1. \u5e94\u7528\u8bbe\u8ba1\u6a21\u5f0f\uff08\u5982\u7b56\u7565\u6a21\u5f0f\uff09\n2. \u63d0\u9ad8\u53ef\u8bfb\u6027\u548c\u53ef\u6d4b\u8bd5\u6027\n3. \u6dfb\u52a0\u6cdb\u578b\u548c\u7c7b\u578b\u5b89\u5168\n4. \u9075\u5faa SOLID \u539f\u5219\n5. \u63d0\u4f9b\u91cd\u6784\u524d\u540e\u7684\u5bf9\u6bd4\u8bf4\u660e", true);
    }
}

