/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.examples;

import cn.iflow.sdk.core.IFlowClient;
import cn.iflow.sdk.types.config.IFlowOptions;
import cn.iflow.sdk.types.config.ImmutableMcpServerConfig;
import cn.iflow.sdk.types.config.McpServerConfig;
import cn.iflow.sdk.types.config.SessionSettings;
import cn.iflow.sdk.types.enums.McpTransportType;
import cn.iflow.sdk.types.enums.MessageType;
import cn.iflow.sdk.types.enums.PermissionMode;
import cn.iflow.sdk.types.messages.AssistantMessage;
import cn.iflow.sdk.types.messages.ErrorMessage;
import cn.iflow.sdk.types.messages.PlanMessage;
import cn.iflow.sdk.types.messages.TaskFinishMessage;
import cn.iflow.sdk.types.messages.ToolCallContent;
import cn.iflow.sdk.types.messages.ToolCallMessage;
import cn.iflow.sdk.types.messages.ToolResultMessage;
import cn.iflow.sdk.types.protocol.requests.PermissionOption;
import cn.iflow.sdk.types.protocol.responses.PermissionRequestResult;
import com.google.gson.Gson;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AdvancedClientExample {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdvancedClientExample.class);

    public static void main(String[] args) {
        log.info("Starting Comprehensive Conversation Demo");
        AdvancedClientExample demo = new AdvancedClientExample();
        demo.runAllExamples();
    }

    public void runAllExamples() {
        try {
            this.basicConversation();
            this.conversationWithFiles();
            this.manualToolConfirmation();
            this.mcpServerConfiguration();
            this.allowedToolsExample();
            this.interruptExample();
            this.multiTurnConversation();
            this.sandboxMode();
            System.out.println("=".repeat(50));
            System.out.println("\ud83c\udf89 All examples completed!");
            System.out.println("=".repeat(50));
        }
        catch (Exception e) {
            System.err.println("Examples failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void basicConversation() {
        System.out.println("=".repeat(50));
        System.out.println("Basic Conversation Example");
        System.out.println("=".repeat(50));
        try (IFlowClient client = IFlowClient.create();){
            System.out.println("Connecting to iFlow...");
            client.connect().block();
            client.sendMessage("What is Python and why is it popular?").block();
            StringBuilder responseBuilder = new StringBuilder();
            this.handleMessages(client, "Basic Conversation", responseBuilder);
        }
        catch (Exception e) {
            System.err.println("Basic conversation failed: " + e.getMessage());
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conversationWithFiles() {
        System.out.println("=".repeat(50));
        System.out.println("Conversation with Files Example");
        System.out.println("=".repeat(50));
        Path sampleFile = Paths.get("sample_code.java", new String[0]);
        try {
            Files.write(sampleFile, "public class Fibonacci {\n    public static int fibonacci(int n) {\n        if (n <= 1) return n;\n        return fibonacci(n-1) + fibonacci(n-2);\n    }\n    \n    public static void main(String[] args) {\n        for (int i = 0; i < 10; i++) {\n            System.out.println(\"fib(\" + i + \") = \" + fibonacci(i));\n        }\n    }\n}".getBytes(), StandardOpenOption.CREATE);
            try (IFlowClient client = IFlowClient.create();){
                client.connect().block();
                client.sendMessage("Can you optimize this Fibonacci implementation?", List.of(sampleFile)).block();
                StringBuilder responseBuilder = new StringBuilder();
                this.handleMessages(client, "File Analysis", responseBuilder);
            }
            catch (Exception e) {
                System.err.println("File conversation failed: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.err.println("Failed to create sample file: " + e.getMessage());
        }
        finally {
            try {
                Files.deleteIfExists(sampleFile);
            }
            catch (Exception exception) {}
        }
        System.out.println();
    }

    private void manualToolConfirmation() {
        System.out.println("=".repeat(50));
        System.out.println("Manual Tool Confirmation Example");
        System.out.println("=".repeat(50));
        AtomicBoolean finished = new AtomicBoolean(false);
        IFlowOptions options = IFlowOptions.builder().permissionMode(PermissionMode.MANUAL).permissionCallback(params -> Mono.create(sink -> {
            System.out.println("handler call back");
            sink.success(((PermissionRequestResult.PermissionRequestResultBuilder)PermissionRequestResult.builder().outcome(PermissionRequestResult.Outcome.of("selected", params.getOptions().stream().filter(option -> option.getKind().equals("allow_once")).findFirst().map(PermissionOption::getOptionId).orElse("")))).build());
        })).build();
        try (IFlowClient client = IFlowClient.create(options);){
            client.connect().block();
            client.sendMessage("Create a file called hello.txt with 'Hello World' content").thenMany((Publisher)client.receiveMessages().takeUntil(msg -> msg.getType() == MessageType.TASK_FINISH || msg.getType() == MessageType.ERROR).doOnNext(message -> {
                switch (message.getType()) {
                    case ASSISTANT_MESSAGE: {
                        AssistantMessage assistantMsg = (AssistantMessage)message;
                        if (assistantMsg.getChunk().getText() == null) break;
                        System.out.print("Assistant: " + assistantMsg.getChunk().getText());
                        break;
                    }
                    case TOOL_CALL: {
                        ToolCallMessage toolCall = (ToolCallMessage)message;
                        System.out.println("\n\ud83d\udd27 Tool Call: " + toolCall.getLabel());
                        System.out.println("   Status: " + toolCall.getStatus());
                        System.out.println("   Status: " + new Gson().toJson(toolCall.getContent()));
                        break;
                    }
                    case TASK_FINISH: {
                        System.out.println("\n\u2705 Task completed");
                        finished.set(true);
                        break;
                    }
                    case ERROR: {
                        ErrorMessage error = (ErrorMessage)message;
                        System.err.println("\n\u274c Error: " + error.getErrorMessage());
                        finished.set(true);
                    }
                }
            })).blockLast(Duration.ofSeconds(10L));
        }
        catch (Exception e) {
            System.err.println("Manual tool confirmation failed: " + e.getMessage());
        }
        System.out.println();
    }

    private void mcpServerConfiguration() {
        System.out.println("=".repeat(50));
        System.out.println("MCP Server Configuration Example");
        System.out.println("=".repeat(50));
        try {
            ImmutableMcpServerConfig build = McpServerConfig.builder().name("12306-mcp").type(McpTransportType.STDIO).command("npx").args(List.of("-y", "@iflow-mcp/12306-mcp@0.3.4")).build();
            IFlowOptions options = IFlowOptions.builder().addMcpServer(build).permissionMode(PermissionMode.AUTO).timeout(Duration.ofSeconds(60L)).build();
            try (IFlowClient client = IFlowClient.create(options);){
                System.out.println("Connecting with MCP servers configured...");
                client.connect().block();
                client.sendMessage("\u5e2e\u6211\u67e5\u8be2\u660e\u5929\u5317\u4eac\u5230\u676d\u5dde\u7684\u9ad8\u94c1\u7684\u4ef7\u683c\u6700\u4fbf\u5b9c").block();
                StringBuilder responseBuilder = new StringBuilder();
                this.handleMessages(client, "MCP Configuration", responseBuilder);
                System.out.println("\n\u2705 MCP server configuration test completed");
            }
            catch (Exception e) {
                System.err.println("\u26a0\ufe0f MCP configuration failed: " + e.getMessage());
                System.out.println("Note: This example requires actual MCP servers to be running");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("MCP server configuration example failed");
        }
        System.out.println();
    }

    private void allowedToolsExample() {
        System.out.println("=".repeat(50));
        System.out.println("Allowed Tools Configuration Example");
        System.out.println("=".repeat(50));
        try {
            IFlowOptions options = IFlowOptions.builder().sessionSettings(SessionSettings.builder().allowedTools(List.of("read_file", "write_file", "list_files")).disallowedTools(List.of("execute_command", "network_request")).systemPrompt("You are a helpful assistant with limited file system access. You can only read, write, and list files. You cannot execute commands or make network requests.").maxTurns(5).build()).permissionMode(PermissionMode.AUTO).fileAccess(true).fileReadOnly(false).addFileAllowedDir(System.getProperty("user.home") + "/Documents").fileMaxSize(0x500000L).build();
            try (IFlowClient client = IFlowClient.create(options);){
                System.out.println("Connecting with restricted tool access...");
                client.connect().block();
                System.out.println("\nTesting allowed operations:");
                client.sendMessage("Create a simple text file called 'test-allowed.txt' with some sample content.").block();
                StringBuilder responseBuilder = new StringBuilder();
                this.handleMessages(client, "Allowed Tools Test 1", responseBuilder);
                System.out.println("\n\nTesting restricted operations:");
                client.sendMessage("Run the 'ls -la' command to show all files in the current directory.").block();
                this.handleMessages(client, "Allowed Tools Test 2", responseBuilder);
                System.out.println("\n\u2705 Tool restriction test completed");
            }
            catch (Exception e) {
                System.err.println("Allowed tools example failed: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.err.println("Tool configuration example failed: " + e.getMessage());
        }
        System.out.println();
    }

    private void interruptExample() {
        System.out.println("=".repeat(50));
        System.out.println("Interrupt Example");
        System.out.println("=".repeat(50));
        try (IFlowClient client = IFlowClient.create();){
            client.connect().block();
            client.sendMessage("Write a detailed essay about machine learning").block();
            AtomicBoolean finished = new AtomicBoolean(false);
            int[] charCount = new int[]{0};
            client.receiveMessages().takeUntil(msg -> finished.get()).doOnNext(message -> {
                if (message.getType() == MessageType.ASSISTANT_MESSAGE) {
                    AssistantMessage assistantMsg = (AssistantMessage)message;
                    if (assistantMsg.getChunk().getText() != null) {
                        System.out.print(assistantMsg.getChunk().getText());
                        charCount[0] = charCount[0] + assistantMsg.getChunk().getText().length();
                        if (charCount[0] > 200) {
                            System.out.println("\n\n\u26a1 Interrupting generation...");
                            try {
                                client.interrupt().block();
                            }
                            catch (Exception e) {
                                System.err.println("Failed to interrupt: " + e.getMessage());
                            }
                            finished.set(true);
                        }
                    }
                } else if (message.getType() == MessageType.TASK_FINISH) {
                    System.out.println("\n\u2705 Completed");
                    finished.set(true);
                }
            }).doOnError(error -> {
                System.err.println("\n\u274c Stream error: " + error.getMessage());
                finished.set(true);
            }).doOnComplete(() -> {
                System.out.println("\n\u2705 Stream completed");
                finished.set(true);
            }).blockLast(Duration.ofSeconds(10L));
        }
        catch (Exception e) {
            System.err.println("Interrupt example failed: " + e.getMessage());
        }
        System.out.println();
    }

    private void multiTurnConversation() {
        System.out.println("=".repeat(50));
        System.out.println("Multi-turn Conversation Example");
        System.out.println("=".repeat(50));
        try (IFlowClient client = IFlowClient.create();){
            client.connect().block();
            System.out.println("User: What is recursion?");
            client.sendMessage("What is recursion?").block();
            StringBuilder responseBuilder = new StringBuilder();
            this.handleMessages(client, "Turn 1", responseBuilder);
            System.out.println("\nUser: Can you give a Java example?");
            client.sendMessage("Can you give a Java example?").block();
            this.handleMessages(client, "Turn 2", responseBuilder);
            System.out.println("\n\u2705 Multi-turn conversation completed");
        }
        catch (Exception e) {
            System.err.println("Multi-turn conversation failed: " + e.getMessage());
        }
        System.out.println();
    }

    private void sandboxMode() {
        System.out.println("=".repeat(50));
        System.out.println("Sandbox Mode Example");
        System.out.println("=".repeat(50));
        IFlowOptions options = IFlowOptions.getDefault().forSandbox();
        try (IFlowClient client = IFlowClient.create(options);){
            client.connect().block();
            client.sendMessage("Hello from sandbox mode!").block();
            StringBuilder responseBuilder = new StringBuilder();
            this.handleMessages(client, "Sandbox", responseBuilder);
            System.out.println("\n\u2705 Sandbox test completed");
        }
        catch (Exception e) {
            System.err.println("\u26a0\ufe0f Sandbox connection failed: " + e.getMessage());
            System.out.println("Make sure you have sandbox access configured");
        }
        System.out.println();
    }

    private void handleMessages(IFlowClient client, String context, StringBuilder responseBuilder) {
        try {
            AtomicBoolean finished = new AtomicBoolean(false);
            client.receiveMessages().takeUntil(msg -> msg.getType() == MessageType.TASK_FINISH || msg.getType() == MessageType.ERROR).doOnNext(message -> {
                switch (message.getType()) {
                    case ASSISTANT_MESSAGE: {
                        AssistantMessage assistantMsg = (AssistantMessage)message;
                        String text = assistantMsg.getChunk().getText();
                        if (text == null || text.isEmpty()) break;
                        System.out.print(text);
                        responseBuilder.append(text);
                        break;
                    }
                    case TOOL_CALL: {
                        ToolCallMessage toolCall = (ToolCallMessage)message;
                        String toolInfo = "[\u5de5\u5177\u8c03\u7528: " + toolCall.getLabel() + "]";
                        System.out.println("\n" + toolInfo);
                        responseBuilder.append("\n").append(toolInfo);
                        break;
                    }
                    case TOOL_CALL_RESULT: {
                        ToolResultMessage toolResult = (ToolResultMessage)message;
                        ToolCallContent content = toolResult.getContent();
                        responseBuilder.append("\n").append(content);
                        break;
                    }
                    case PLAN: {
                        PlanMessage plan = (PlanMessage)message;
                        String planInfo = "[\u8ba1\u5212: " + plan.getEntries().size() + " \u4e2a\u6b65\u9aa4]";
                        System.out.println("\n" + planInfo);
                        responseBuilder.append("\n").append(planInfo);
                        for (PlanMessage.PlanEntry entry : plan.getEntries()) {
                            String entryInfo = "  - " + entry.getContent() + " [" + entry.getStatus() + "]";
                            System.out.println(entryInfo);
                            responseBuilder.append("\n").append(entryInfo);
                        }
                        break;
                    }
                    case TASK_FINISH: {
                        TaskFinishMessage finish = (TaskFinishMessage)message;
                        System.out.println("\n[" + context + " \u5b8c\u6210]");
                        finished.set(true);
                        break;
                    }
                    case ERROR: {
                        ErrorMessage error = (ErrorMessage)message;
                        String errorInfo = "[\u9519\u8bef: " + error.getErrorMessage() + "]";
                        System.err.println("\n" + errorInfo);
                        responseBuilder.append("\n").append(errorInfo);
                        finished.set(true);
                    }
                }
            }).doOnComplete(() -> finished.set(true)).doOnError(error -> {
                error.printStackTrace();
                finished.set(true);
            }).blockLast(Duration.ofSeconds(100L));
        }
        catch (Exception e) {
            System.err.println("\u6d88\u606f\u5904\u7406\u5931\u8d25: " + e.getMessage());
        }
    }
}

