/*
 * Decompiled with CFR 0.152.
 */
package cn.ideabuffer.process.api.model.processor;

import cn.ideabuffer.process.api.model.Model;
import cn.ideabuffer.process.api.model.ModelBuilderFactory;
import cn.ideabuffer.process.api.model.builder.BranchNodeModelBuilder;
import cn.ideabuffer.process.api.model.builder.ModelBuilder;
import cn.ideabuffer.process.api.model.node.BranchNodeModel;
import cn.ideabuffer.process.api.model.processor.ProcessorModel;
import cn.ideabuffer.process.core.nodes.TryCatchFinallyNode;
import cn.ideabuffer.process.core.nodes.branch.BranchNode;
import cn.ideabuffer.process.core.processors.TryCatchFinallyProcessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TryCatchFinallyProcessorModel<R extends TryCatchFinallyProcessor>
extends ProcessorModel<R> {
    private static final long serialVersionUID = 1656596845938118061L;
    private BranchNodeModel tryBranchModel;
    private List<CatchMapperModel> catchMapperModels;
    private BranchNodeModel finallyBranchModel;

    public TryCatchFinallyProcessorModel(@NotNull R processor) {
        super(processor);
    }

    public BranchNodeModel getTryBranchModel() {
        return this.tryBranchModel;
    }

    public void setTryBranchModel(BranchNodeModel tryBranchModel) {
        this.tryBranchModel = tryBranchModel;
    }

    public List<CatchMapperModel> getCatchMapperModels() {
        return this.catchMapperModels;
    }

    public void setCatchMapperModels(List<CatchMapperModel> catchMapperModels) {
        this.catchMapperModels = catchMapperModels;
    }

    public BranchNodeModel getFinallyBranchModel() {
        return this.finallyBranchModel;
    }

    public void setFinallyBranchModel(BranchNodeModel finallyBranchModel) {
        this.finallyBranchModel = finallyBranchModel;
    }

    @Override
    public void init() {
        BranchNode finallyBranch;
        BranchNodeModelBuilder finallyBranchModelBuilder;
        List catchMappers;
        super.init();
        ModelBuilderFactory factory = ModelBuilderFactory.getInstance();
        BranchNode tryBranch = ((TryCatchFinallyProcessor)this.resource).getTryBranch();
        BranchNodeModelBuilder tryBranchModelBuilder = (BranchNodeModelBuilder)factory.getModelBuilder(tryBranch);
        if (tryBranchModelBuilder != null) {
            this.tryBranchModel = tryBranchModelBuilder.build(tryBranch);
        }
        if ((catchMappers = ((TryCatchFinallyProcessor)this.resource).getCatchMapperList()) != null && !catchMappers.isEmpty()) {
            this.catchMapperModels = new ArrayList<CatchMapperModel>(catchMappers.size());
            catchMappers.forEach(catchMapper -> {
                CatchMapperModelBuilder builder = (CatchMapperModelBuilder)factory.getModelBuilder(catchMapper);
                if (builder != null) {
                    this.catchMapperModels.add(builder.build((TryCatchFinallyNode.CatchMapper)catchMapper));
                }
            });
        }
        if ((finallyBranchModelBuilder = (BranchNodeModelBuilder)factory.getModelBuilder(finallyBranch = ((TryCatchFinallyProcessor)this.resource).getFinallyBranch())) != null) {
            this.finallyBranchModel = finallyBranchModelBuilder.build(finallyBranch);
        }
    }

    public static class CatchMapperModelBuilder
    extends ModelBuilder<TryCatchFinallyNode.CatchMapper> {
        public CatchMapperModel build(TryCatchFinallyNode.CatchMapper resource) {
            return new CatchMapperModel(resource);
        }
    }

    public static class CatchMapperModel
    extends Model<TryCatchFinallyNode.CatchMapper> {
        private static final long serialVersionUID = 2184647179857736021L;
        private String expClassName;
        private BranchNodeModel branchNodeModel;

        public CatchMapperModel(@NotNull TryCatchFinallyNode.CatchMapper resource) {
            super(resource);
        }

        public String getExpClassName() {
            return this.expClassName;
        }

        public void setExpClassName(String expClassName) {
            this.expClassName = expClassName;
        }

        public BranchNodeModel getBranchNodeModel() {
            return this.branchNodeModel;
        }

        public void setBranchNodeModel(BranchNodeModel branchNodeModel) {
            this.branchNodeModel = branchNodeModel;
        }

        @Override
        protected void init() {
            BranchNode branchNode;
            super.init();
            Class expClass = ((TryCatchFinallyNode.CatchMapper)this.resource).getExceptionClass();
            if (expClass != null) {
                this.expClassName = expClass.getName();
            }
            if ((branchNode = ((TryCatchFinallyNode.CatchMapper)this.resource).getBranchNode()) != null) {
                this.branchNodeModel = ((BranchNodeModelBuilder)ModelBuilderFactory.getInstance().getModelBuilder(branchNode)).build(branchNode);
            }
        }
    }
}

