/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.secure.utils;

import cn.hutool.core.net.URLDecoder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlInjectionUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlInjectionUtils.class);
    private static final String SQL_REGEX = "\\b(and|or)\\b.{1,6}?(=|>|<|\\bin\\b|\\blike\\b)|\\/\\*.+?\\*\\/|<\\s*script\\b|\\bEXEC\\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\\s+INTO.+?VALUES|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\\s+(TABLE|DATABASE)";
    private static final Pattern SQL_PATTERN = Pattern.compile("\\b(and|or)\\b.{1,6}?(=|>|<|\\bin\\b|\\blike\\b)|\\/\\*.+?\\*\\/|<\\s*script\\b|\\bEXEC\\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\\s+INTO.+?VALUES|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\\s+(TABLE|DATABASE)", 2);

    private static boolean matching(String lowerValue, String param) {
        if (SQL_PATTERN.matcher(param).find()) {
            log.error("[Herodotus] |- The parameter contains keywords {} that do not allow SQL!", (Object)lowerValue);
            return true;
        }
        return false;
    }

    private static String toLowerCase(Object obj) {
        return Optional.ofNullable(obj).map(Object::toString).map(String::toLowerCase).orElse("");
    }

    private static boolean checking(Object value) {
        String lowerValue = SqlInjectionUtils.toLowerCase(value);
        return SqlInjectionUtils.matching(lowerValue, lowerValue);
    }

    public static boolean checkForGet(String value) {
        String lowerValue = URLDecoder.decode((String)value, (Charset)StandardCharsets.UTF_8).toLowerCase();
        return ((Stream)Stream.of(lowerValue.split("\\&")).map(kp -> kp.substring(kp.indexOf("=") + 1)).parallel()).anyMatch(param -> SqlInjectionUtils.matching(lowerValue, param));
    }

    public static boolean checkForPost(String value) {
        Object jsonObj = JSON.parse((String)value);
        if (jsonObj instanceof JSONObject) {
            JSONObject json = (JSONObject)jsonObj;
            return ((Stream)json.entrySet().stream().parallel()).anyMatch(entry -> SqlInjectionUtils.checking(entry.getValue()));
        }
        if (jsonObj instanceof JSONArray) {
            JSONArray json = (JSONArray)jsonObj;
            return ((Stream)json.stream().parallel()).anyMatch(SqlInjectionUtils::checking);
        }
        return false;
    }
}

